/*
 * Decompiled with CFR 0.152.
 */
package eu.fbk.utils.svm;

import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Ordering;
import com.google.common.collect.Sets;
import com.google.common.collect.UnmodifiableIterator;
import eu.fbk.utils.core.Dictionary;
import eu.fbk.utils.svm.LabelledVector;
import java.io.IOException;
import java.io.Serializable;
import java.util.AbstractSet;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class Vector
implements Serializable,
Comparable<Vector> {
    private static final Logger LOGGER = LoggerFactory.getLogger(Vector.class);
    private static final long serialVersionUID = 2L;
    private final String id;

    Vector(String id) {
        this.id = id;
    }

    public final String getId() {
        return this.id;
    }

    static Vector create(@Nullable Map<String, Float> map) {
        return Vector.create(map, null);
    }

    static Vector create(@Nullable Map<String, Float> map, @Nullable String id) {
        Vector ret;
        int size;
        int n = size = map == null ? 0 : map.size();
        if (size == 0) {
            ret = new Vector0(id);
        } else if (size == 1) {
            Map.Entry<String, Float> entry = map.entrySet().iterator().next();
            ret = new Vector1(entry.getKey().intern(), entry.getValue().floatValue(), id);
        } else {
            Object[] features = map.keySet().toArray(new String[size]);
            Arrays.sort(features);
            float[] values = new float[size];
            boolean allOnes = true;
            for (int i = 0; i < size; ++i) {
                features[i] = ((String)features[i]).intern();
                values[i] = map.get(features[i]).floatValue();
                allOnes &= values[i] == 1.0f;
            }
            ret = allOnes ? new VectorAllOnes((String[])features, id) : new VectorN((String[])features, values, id);
        }
        return ret;
    }

    abstract int doSize();

    abstract String doGetFeature(int var1);

    abstract float doGetValue(int var1);

    LabelledVector doLabel(int label, float ... probabilities) {
        Vector unlabel = this.unlabel();
        LabelledVector ret = LabelledVector.create(unlabel, label, probabilities);
        return ret;
    }

    Vector doUnlabel() {
        return this;
    }

    void doToString(Appendable out) throws IOException {
        int size = this.doSize();
        for (int i = 0; i < size; ++i) {
            out.append(i == 0 ? "" : " ");
            out.append(this.doGetFeature(i)).append(":").append(Float.toString(this.doGetValue(i)));
        }
    }

    private void checkFeatureIndex(int index) {
        if (index < 0 || index >= this.size()) {
            throw new IllegalArgumentException("Invalid feature index " + index + " (size " + this.doSize() + ")");
        }
    }

    public final int size() {
        return this.doSize();
    }

    public final boolean isEmpty() {
        return this.doSize() == 0;
    }

    public final String getFeature(int index) {
        this.checkFeatureIndex(index);
        return this.doGetFeature(index);
    }

    public final Set<String> getFeatures() {
        return new AbstractSet<String>(){

            @Override
            public int size() {
                return Vector.this.doSize();
            }

            @Override
            public boolean contains(Object object) {
                return object instanceof String && Vector.this.hasFeature((String)object);
            }

            @Override
            public Iterator<String> iterator() {
                return new UnmodifiableIterator<String>(){
                    private int index = 0;

                    @Override
                    public boolean hasNext() {
                        return this.index < Vector.this.doSize();
                    }

                    @Override
                    public String next() {
                        return Vector.this.getFeature(this.index++);
                    }
                };
            }
        };
    }

    public Set<String> getFeatures(final String prefix) {
        return Sets.filter(this.getFeatures(), new Predicate<String>(){

            @Override
            public boolean apply(String feature) {
                return feature.startsWith(prefix);
            }
        });
    }

    public final boolean hasFeature(String feature) {
        return (double)this.getValue(feature) != 0.0;
    }

    public final float getValue(int index) {
        this.checkFeatureIndex(index);
        return this.doGetValue(index);
    }

    public final float getValue(String feature) {
        String internedFeature = feature.intern();
        int size = this.doSize();
        for (int i = 0; i < size; ++i) {
            if (this.doGetFeature(i) != internedFeature) continue;
            return this.doGetValue(i);
        }
        return 0.0f;
    }

    public final LabelledVector label(int label, float ... probabilities) {
        if (probabilities != null && probabilities.length > 0) {
            float sum = 0.0f;
            for (int i = 0; i < probabilities.length; ++i) {
                sum += probabilities[i];
            }
            if (Math.abs(sum - 1.0f) > 0.01f) {
                throw new IllegalArgumentException("Supplied probabilities sum to " + sum);
            }
        }
        return this.doLabel(label, probabilities);
    }

    public final Vector unlabel() {
        return this.doUnlabel();
    }

    @Override
    public int compareTo(Vector other) {
        int thisSize = this.doSize();
        int otherSize = other.doSize();
        int minSize = Math.min(thisSize, otherSize);
        for (int i = 0; i < minSize; ++i) {
            int result = this.doGetFeature(i).compareTo(other.doGetFeature(i));
            if (result != 0) {
                return result;
            }
            result = Float.compare(this.doGetValue(i), other.doGetValue(i));
            if (result == 0) continue;
            return result;
        }
        return thisSize - otherSize;
    }

    public final boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof Vector)) {
            return false;
        }
        Vector other = (Vector)object;
        int size = this.doSize();
        if (size != other.doSize()) {
            return false;
        }
        for (int i = 0; i < size; ++i) {
            if (this.doGetFeature(i) == other.doGetFeature(i) && this.doGetValue(i) == other.doGetValue(i)) continue;
            return false;
        }
        return true;
    }

    public final int hashCode() {
        int result = 0;
        int size = this.doSize();
        for (int i = 0; i < size; ++i) {
            result = result * 983 + this.doGetFeature(i).hashCode() * 37 + Float.hashCode(this.doGetValue(i));
        }
        return result;
    }

    public final void toString(Appendable out) throws IOException {
        this.doToString(out);
    }

    public final String toString() {
        StringBuilder builder = new StringBuilder();
        try {
            this.doToString(builder);
        }
        catch (IOException ex) {
            throw new Error(ex);
        }
        return builder.toString();
    }

    public static <T extends Appendable> T write(Iterable<? extends Vector> vectors, Dictionary<String> dictionary, T out) throws IOException {
        for (Vector vector : vectors) {
            out.append(vector instanceof LabelledVector ? Integer.toString(((LabelledVector)vector).getLabel()) : "0");
            int size = vector.size();
            ArrayList<IndexValue> vs = Lists.newArrayListWithCapacity(size);
            for (int i = 0; i < size; ++i) {
                Integer featureIndex;
                String feature = vector.getFeature(i);
                if (feature.charAt(0) == '_' || (featureIndex = dictionary.indexFor(vector.getFeature(i))) == null) continue;
                vs.add(new IndexValue(featureIndex, vector.getValue(i)));
            }
            Collections.sort(vs);
            for (IndexValue v : vs) {
                out.append(' ');
                out.append(Integer.toString(v.index));
                out.append(':');
                out.append(Float.toString(v.value));
            }
            out.append('\n');
        }
        return out;
    }

    /*
     * WARNING - void declaration
     */
    public static <T extends Vector> List<List<T>> split(Iterable<T> vectors, int numPartitions, int maxVectors) {
        Preconditions.checkNotNull(vectors);
        Preconditions.checkArgument(numPartitions > 0);
        HashMap labelIndex = Maps.newHashMap();
        HashMap clusterIndex = Maps.newHashMap();
        int[] distribution = new int[1];
        int totalVectors = 0;
        for (Vector vector : Ordering.natural().immutableSortedCopy(vectors)) {
            void var11_25;
            int label = vector instanceof LabelledVector ? ((LabelledVector)vector).getLabel() : 0;
            distribution = label < distribution.length ? distribution : Arrays.copyOf(distribution, label + 1);
            int n = label;
            distribution[n] = distribution[n] + 1;
            ++totalVectors;
            String clusterID = null;
            for (String string : vector.getFeatures("_cluster.")) {
                if (clusterID == null) {
                    clusterID = string;
                    continue;
                }
                LOGGER.warn("Ignoring extra cluster assignment: " + string);
            }
            if (clusterID == null) {
                void var11_22;
                List list = (List)labelIndex.get(label);
                if (list == null) {
                    ArrayList arrayList = Lists.newArrayList();
                    labelIndex.put(label, arrayList);
                }
                var11_22.add(vector);
                continue;
            }
            SplitCluster splitCluster = (SplitCluster)clusterIndex.get(clusterID);
            if (splitCluster == null) {
                SplitCluster splitCluster2 = new SplitCluster(clusterID);
                clusterIndex.put(clusterID, splitCluster2);
            }
            var11_25.add(label, vector);
        }
        if (totalVectors > maxVectors) {
            float scale = (float)maxVectors / (float)totalVectors;
            for (int i = 0; i < distribution.length; ++i) {
                distribution[i] = (int)((float)distribution[i] * scale);
            }
        }
        ArrayList partitions = Lists.newArrayList();
        for (int i = 0; i < numPartitions; ++i) {
            partitions.add(new SplitCluster(Integer.toString(i)));
        }
        int allocated = 0;
        for (SplitCluster cluster : Ordering.natural().sortedCopy(clusterIndex.values())) {
            void var11_28;
            if (maxVectors > 0 && allocated + cluster.vectors.size() > maxVectors) break;
            Object var11_27 = null;
            for (SplitCluster splitCluster : partitions) {
                if (var11_28 != null && splitCluster.vectors.size() >= var11_28.vectors.size()) continue;
                SplitCluster splitCluster3 = splitCluster;
            }
            var11_28.add(cluster);
            allocated += cluster.vectors.size();
        }
        block6: for (Integer label : Ordering.natural().sortedCopy(labelIndex.keySet())) {
            for (Vector vector : (List)labelIndex.get(label)) {
                void var13_44;
                Object var13_43 = null;
                int selectedDelta = 0;
                for (SplitCluster splitCluster : partitions) {
                    int count = label >= splitCluster.distribution.length ? 0 : splitCluster.distribution[label];
                    int delta = distribution[label] - numPartitions * count;
                    if (var13_44 != null && delta <= selectedDelta) continue;
                    SplitCluster splitCluster4 = splitCluster;
                    selectedDelta = delta;
                }
                if (allocated >= maxVectors) break block6;
                if (selectedDelta <= 0) continue block6;
                var13_44.add(label, vector);
                ++allocated;
            }
        }
        if (LOGGER.isDebugEnabled()) {
            StringBuilder builder = new StringBuilder("Split results:");
            for (int i = 0; i < partitions.size(); ++i) {
                SplitCluster splitCluster = (SplitCluster)partitions.get(i);
                builder.append("\n- partition ").append(i).append(": ").append(splitCluster.vectors.size()).append(" vectors ").append(Arrays.toString(splitCluster.distribution));
            }
            LOGGER.debug(builder.toString());
        }
        ArrayList<List<T>> result = Lists.newArrayList();
        for (SplitCluster splitCluster : partitions) {
            result.add(splitCluster.vectors);
        }
        return result;
    }

    public static Builder builder() {
        return new Builder(null);
    }

    public static Builder builder(Vector vector) {
        return new Builder(vector.unlabel());
    }

    private static final class VectorAllOnes
    extends Vector {
        private static final long serialVersionUID = 2L;
        private final String[] features;

        VectorAllOnes(String[] features) {
            this(features, null);
        }

        VectorAllOnes(String[] features, @Nullable String id) {
            super(id);
            this.features = features;
        }

        @Override
        int doSize() {
            return this.features.length;
        }

        @Override
        String doGetFeature(int index) {
            return this.features[index];
        }

        @Override
        float doGetValue(int index) {
            return 1.0f;
        }
    }

    private static final class VectorN
    extends Vector {
        private static final long serialVersionUID = 2L;
        private final String[] features;
        private final float[] values;

        VectorN(String[] features, float[] values) {
            this(features, values, null);
        }

        VectorN(String[] features, float[] values, String id) {
            super(id);
            this.features = features;
            this.values = values;
        }

        @Override
        int doSize() {
            return this.features.length;
        }

        @Override
        String doGetFeature(int index) {
            return this.features[index];
        }

        @Override
        float doGetValue(int index) {
            return this.values[index];
        }
    }

    private static final class Vector1
    extends Vector {
        private static final long serialVersionUID = 2L;
        private final String feature;
        private final float value;

        Vector1(String feature, float value) {
            this(feature, value, null);
        }

        Vector1(String feature, float value, @Nullable String id) {
            super(id);
            this.feature = feature;
            this.value = value;
        }

        @Override
        int doSize() {
            return 1;
        }

        @Override
        String doGetFeature(int index) {
            if (index == 0) {
                return this.feature;
            }
            throw new IndexOutOfBoundsException();
        }

        @Override
        float doGetValue(int index) {
            if (index == 0) {
                return this.value;
            }
            throw new IndexOutOfBoundsException();
        }
    }

    private static final class Vector0
    extends Vector {
        private static final long serialVersionUID = 2L;

        Vector0(@Nullable String id) {
            super(id);
        }

        @Override
        int doSize() {
            return 0;
        }

        @Override
        String doGetFeature(int index) {
            throw new IndexOutOfBoundsException();
        }

        @Override
        float doGetValue(int index) {
            throw new IndexOutOfBoundsException();
        }
    }

    public static final class Builder {
        @Nullable
        private Vector vector;
        private String id;
        @Nullable
        private Map<String, Float> map;
        @Nullable
        private String prefix;

        Builder(@Nullable Vector vector) {
            this.vector = vector;
            this.map = null;
        }

        public float get(String feature) {
            String actualFeature;
            String string = actualFeature = this.prefix == null ? feature : this.prefix + feature;
            if (this.map != null) {
                Float value = this.map.get(actualFeature);
                return value == null ? 0.0f : value.floatValue();
            }
            if (this.vector != null) {
                return this.vector.getValue(actualFeature);
            }
            return 0.0f;
        }

        public Builder setID(String id) {
            this.id = id;
            return this;
        }

        public Builder set(String feature, float value) {
            String actualFeature;
            String string = actualFeature = this.prefix == null ? feature : this.prefix + feature;
            if (this.map != null) {
                if (value == 0.0f) {
                    this.map.remove(actualFeature);
                    if (this.map.isEmpty()) {
                        this.map = null;
                    }
                } else {
                    this.map.put(actualFeature, Float.valueOf(value));
                }
            } else if (this.vector != null) {
                if (value != this.vector.getValue(actualFeature)) {
                    Vector v = this.vector;
                    this.vector = null;
                    this.map = Maps.newHashMap();
                    this.set(v);
                    this.set(actualFeature, value);
                }
            } else if (value != 0.0f) {
                this.map = Maps.newHashMap();
                this.map.put(actualFeature, Float.valueOf(value));
            }
            return this;
        }

        public Builder set(String feature, boolean value) {
            return this.set(feature, value ? 1.0f : 0.0f);
        }

        public Builder set(String ... features) {
            for (String feature : features) {
                this.set(feature, 1.0f);
            }
            return this;
        }

        public Builder set(Iterable<String> features) {
            for (String feature : features) {
                this.set(feature, 1.0f);
            }
            return this;
        }

        public Builder set(String prefix, Iterable<String> features) {
            for (String feature : features) {
                this.set(prefix + feature, 1.0f);
            }
            return this;
        }

        public Builder set(Vector vector) {
            int size = vector.doSize();
            for (int i = 0; i < size; ++i) {
                this.set(vector.doGetFeature(i), vector.doGetValue(i));
            }
            return this;
        }

        public Builder clear(String ... features) {
            for (String feature : features) {
                this.set(feature, 0.0f);
            }
            return this;
        }

        public Builder clear(Iterable<String> features) {
            for (String feature : features) {
                this.set(feature, 0.0f);
            }
            return this;
        }

        public Builder prefix(@Nullable String prefix) {
            this.prefix = prefix;
            return this;
        }

        public Vector build() {
            return this.vector != null ? this.vector : Vector.create(this.map, this.id);
        }
    }

    private static final class SplitCluster<T extends Vector>
    implements Comparable<SplitCluster<T>> {
        private static final int[] EMPTY_DISTRIBUTION = new int[0];
        String id;
        int[] distribution;
        List<T> vectors;

        SplitCluster(String id) {
            this.id = id;
            this.distribution = EMPTY_DISTRIBUTION;
            this.vectors = Lists.newArrayList();
        }

        void add(SplitCluster<T> cluster) {
            this.vectors.addAll(cluster.vectors);
            if (this.distribution.length < cluster.distribution.length) {
                this.distribution = Arrays.copyOf(this.distribution, cluster.distribution.length);
            }
            for (int i = 0; i < cluster.distribution.length; ++i) {
                int n = i;
                this.distribution[n] = this.distribution[n] + cluster.distribution[i];
            }
        }

        void add(int label, T vector) {
            this.vectors.add(vector);
            if (label >= this.distribution.length) {
                this.distribution = Arrays.copyOf(this.distribution, label + 1);
            }
            int n = label;
            this.distribution[n] = this.distribution[n] + 1;
        }

        @Override
        public int compareTo(SplitCluster<T> other) {
            int result = other.vectors.size() - this.vectors.size();
            if (result == 0) {
                result = this.id.compareTo(other.id);
            }
            return result;
        }
    }

    private static final class IndexValue
    implements Comparable<IndexValue> {
        private final int index;
        private final float value;

        public IndexValue(int index, float value) {
            this.index = index;
            this.value = value;
        }

        @Override
        public int compareTo(IndexValue other) {
            return this.index - other.index;
        }
    }
}

