/*
 * Decompiled with CFR 0.152.
 */
package eu.fbk.utils.svm;

import com.google.common.base.Charsets;
import com.google.common.collect.HashBasedTable;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.google.common.collect.Ordering;
import com.google.common.collect.Sets;
import eu.fbk.utils.core.Environment;
import eu.fbk.utils.core.IO;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.lang.reflect.Array;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.List;
import java.util.Properties;
import java.util.function.BiFunction;
import java.util.function.Function;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class Util {
    private static final Logger LOGGER = LoggerFactory.getLogger(Util.class);
    public static final Properties PROPERTIES = new Properties();

    public static Properties parseProperties(String string) {
        Properties properties = new Properties();
        int len = string.length();
        String key = null;
        int index = 0;
        while (true) {
            int end;
            int newIndex;
            if ((newIndex = string.indexOf(61, index)) < 0) {
                if (key == null || len <= index) break;
                properties.setProperty(key, string.substring(index, len).trim());
                break;
            }
            for (end = newIndex - 1; end >= 0 && Character.isWhitespace(string.charAt(end)); --end) {
            }
            if (end > 0) {
                int start;
                for (start = end; start > 0 && !Character.isWhitespace(string.charAt(start - 1)); --start) {
                }
                if (key != null && start > index) {
                    properties.setProperty(key, string.substring(index, start).trim());
                }
                key = string.substring(start, end + 1);
            }
            index = newIndex + 1;
        }
        return properties;
    }

    public static void deleteRecursively(Path path) throws IOException {
        Files.walkFileTree(path, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

            @Override
            public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                Files.delete(file);
                return FileVisitResult.CONTINUE;
            }

            @Override
            public FileVisitResult postVisitDirectory(Path dir, IOException exc) throws IOException {
                Files.delete(dir);
                return FileVisitResult.CONTINUE;
            }
        });
    }

    public static Path openVFS(Path rootPath, boolean clean) throws IOException {
        if (Files.isDirectory(rootPath, new LinkOption[0])) {
            if (clean) {
                Util.deleteRecursively(rootPath);
                Files.createDirectory(rootPath, new FileAttribute[0]);
            }
            return rootPath;
        }
        if (rootPath.toString().endsWith(".zip") && rootPath.getFileSystem() == FileSystems.getDefault()) {
            boolean exists = Files.exists(rootPath, new LinkOption[0]);
            if (clean && exists) {
                Files.delete(rootPath);
                exists = false;
            }
            if (!exists) {
                try (OutputStream stream = Files.newOutputStream(rootPath, StandardOpenOption.CREATE);){
                    stream.write(new byte[]{80, 75, 5, 6, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0});
                }
            }
            FileSystem fs = FileSystems.newFileSystem(rootPath, null);
            return fs.getRootDirectories().iterator().next();
        }
        Files.createDirectories(rootPath, new FileAttribute[0]);
        return rootPath;
    }

    public static void closeVFS(Path rootPath) throws IOException {
        if (rootPath.getParent() == null && rootPath.getFileSystem() != FileSystems.getDefault()) {
            rootPath.getFileSystem().close();
        }
    }

    public static Function<String, String> fileRenamer(final String fromPath, final String toPath, final @Nullable String toExtension, final boolean junkPaths) {
        return new Function<String, String>(){

            @Override
            public String apply(String path) {
                String name = !path.startsWith(fromPath) || junkPaths ? Paths.get(path, new String[0]).getFileName().toString() : path.substring(fromPath.length());
                if (toExtension != null) {
                    int index;
                    while ((index = name.lastIndexOf(46)) >= 0 && name.length() - index <= 4) {
                        name = name.substring(0, index);
                    }
                    name = name + (toExtension.startsWith(".") ? "" : ".") + toExtension;
                }
                return toPath + name;
            }
        };
    }

    @Nullable
    public static List<Path> fileMatch(@Nullable Iterable<Path> filesOrDirs, @Nullable Iterable<String> extensions, boolean recursive) {
        try {
            return Util.fileMatch(filesOrDirs, extensions, recursive, false);
        }
        catch (IOException ex) {
            throw new Error(ex);
        }
    }

    @Nullable
    public static List<Path> fileMatch(@Nullable Iterable<Path> filesOrDirs, final @Nullable Iterable<String> extensions, final boolean recursive, boolean indirect) throws IOException {
        if (!indirect && filesOrDirs == null) {
            return null;
        }
        final ArrayList<Path> files = Lists.newArrayList();
        if (filesOrDirs != null) {
            for (final Path path : filesOrDirs) {
                if (!Files.exists(path, new LinkOption[0])) {
                    throw new IllegalArgumentException("No such file or directory: " + path);
                }
                if (Files.isRegularFile(path, new LinkOption[0])) {
                    files.add(path);
                    continue;
                }
                Files.walkFileTree(path, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

                    @Override
                    public FileVisitResult preVisitDirectory(Path dir, BasicFileAttributes attrs) throws IOException {
                        return recursive || dir.equals(path) ? FileVisitResult.CONTINUE : FileVisitResult.SKIP_SUBTREE;
                    }

                    @Override
                    public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                        if (extensions == null) {
                            files.add(file);
                        } else {
                            for (String extension : extensions) {
                                if (!file.toString().endsWith(extension)) continue;
                                files.add(file);
                                break;
                            }
                        }
                        return FileVisitResult.CONTINUE;
                    }
                });
            }
        }
        ArrayList<Path> result = files;
        if (indirect) {
            if (filesOrDirs == null) {
                try (BufferedReader reader = new BufferedReader(IO.utf8Reader(IO.buffer(System.in)));){
                    String line = null;
                    while ((line = reader.readLine()) != null) {
                        result.add(Paths.get(line.trim(), new String[0]));
                    }
                }
            } else {
                result = Lists.newArrayList();
                for (Path file : files) {
                    for (String line : Files.readAllLines(file, Charsets.UTF_8)) {
                        files.add(Paths.get(line.trim(), new String[0]));
                    }
                }
            }
        }
        Collections.sort(result);
        return result;
    }

    public static <T> T[] newArray(Class<T> clazz, Object ... elements) {
        T[] array = Util.newArray(clazz, elements.length);
        for (int i = 0; i < elements.length; ++i) {
            array[i] = elements[i];
        }
        return array;
    }

    public static <T> T[] newArray(Class<T> clazz, int length) {
        return (Object[])Array.newInstance(clazz, length);
    }

    public static <T> T[][] newArray(Class<T> clazz, int length1, int length2) {
        Class<?> elementClass = Util.newArray(clazz, 0).getClass();
        Object[][] array = (Object[][])Util.newArray(elementClass, length1);
        if (length2 > 0) {
            for (int i = 0; i < length1; ++i) {
                array[i] = Util.newArray(clazz, length2);
            }
        }
        return array;
    }

    @Nullable
    public static String cleanIRI(@Nullable String string) throws IllegalArgumentException {
        if (string == null) {
            return null;
        }
        StringBuilder builder = new StringBuilder();
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            if (c >= 'a' && c <= 'z' || c >= '?' && c <= '[' || c >= '&' && c <= ';' || c == '#' || c == '$' || c == '!' || c == '=' || c == ']' || c == '_' || c == '~' || c >= '\u00a0' && c <= '\ud7ff' || c >= '\uf900' && c <= '\ufdcf' || c >= '\ufdf0' && c <= '\uffef') {
                builder.append(c);
                continue;
            }
            if (c == '%' && i < string.length() - 2 && Character.digit(string.charAt(i + 1), 16) >= 0 && Character.digit(string.charAt(i + 2), 16) >= 0) {
                builder.append('%');
                continue;
            }
            builder.append('%').append(Character.forDigit(c / 16, 16)).append(Character.forDigit(c % 16, 16));
        }
        return builder.toString();
    }

    public static String[] hardTokenize(String text) {
        char currentChar;
        if (text.length() == 0) {
            return new String[0];
        }
        ArrayList<String> list = new ArrayList<String>();
        char previousChar = currentChar = text.charAt(0);
        int start = 0;
        if (!Character.isLetterOrDigit(currentChar) && !Character.isWhitespace(currentChar)) {
            list.add(new String(new char[]{currentChar}));
        }
        for (int i = 1; i < text.length(); ++i) {
            currentChar = text.charAt(i);
            boolean isCurrentCharLetterOrDigit = Character.isLetterOrDigit(currentChar);
            boolean isPreviousCharLetterOrDigit = Character.isLetterOrDigit(previousChar);
            if (isCurrentCharLetterOrDigit) {
                if (!isPreviousCharLetterOrDigit) {
                    start = i;
                }
            } else if (isPreviousCharLetterOrDigit) {
                list.add(text.substring(start, i));
                if (!Character.isWhitespace(currentChar)) {
                    list.add(new String(new char[]{currentChar}));
                }
            } else if (!Character.isWhitespace(currentChar)) {
                list.add(new String(new char[]{currentChar}));
            }
            previousChar = currentChar;
        }
        if (Character.isLetterOrDigit(previousChar)) {
            list.add(text.substring(start, text.length()));
        }
        return list.toArray(new String[list.size()]);
    }

    public static double coverage(@Nullable Iterable<?> covered, @Nullable Iterable<?> covering) {
        ImmutableSet<Object> coveredSet;
        ImmutableSet<Object> coveringSet = covering == null ? ImmutableSet.of() : ImmutableSet.copyOf(covering);
        ImmutableSet<Object> immutableSet = coveredSet = covered == null ? ImmutableSet.of() : ImmutableSet.copyOf(covered);
        if (coveredSet.isEmpty()) {
            return coveringSet.isEmpty() ? 1.0 : 0.0;
        }
        int num = Sets.intersection(coveringSet, coveredSet).size();
        int den = coveredSet.size();
        return (double)num / (double)den;
    }

    public static <T, E extends T> T[][] align(Class<T> clazz, Iterable<E> objects1, Iterable<E> objects2, boolean functional, boolean invFunctional, boolean emitUnaligned, BiFunction<? super E, ? super E, ?> matcher) {
        HashBasedTable<E, E, AlignPair<E>> table = HashBasedTable.create();
        for (E object1 : objects1) {
            for (E object2 : objects2) {
                Object similarity = matcher.apply(object1, object2);
                table.put(object1, object2, new AlignPair<E>(object1, object2, similarity));
            }
        }
        HashSet<E> set1 = emitUnaligned ? Sets.newHashSet(objects1) : null;
        HashSet<E> set2 = emitUnaligned ? Sets.newHashSet(objects2) : null;
        ArrayList<T[]> pairs = Lists.newArrayList();
        while (!table.isEmpty()) {
            AlignPair bestPair = (AlignPair)Ordering.natural().max(table.values());
            if (bestPair.similarity == null) break;
            T[] pair = Util.newArray(clazz, bestPair.object1, bestPair.object2);
            pairs.add(pair);
            if (functional) {
                table.rowKeySet().remove(bestPair.object1);
            }
            if (invFunctional) {
                table.columnKeySet().remove(bestPair.object2);
            }
            if (!functional && !invFunctional) {
                table.remove(bestPair.object1, bestPair.object2);
            }
            if (!emitUnaligned) continue;
            set1.remove(bestPair.object1);
            set2.remove(bestPair.object2);
        }
        if (emitUnaligned) {
            for (Object object1 : set1) {
                pairs.add(Util.newArray(clazz, object1, null));
            }
            for (Object object2 : set2) {
                pairs.add(Util.newArray(clazz, null, object2));
            }
        }
        return (Object[][])pairs.toArray((T[])Util.newArray(clazz, pairs.size(), -1));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static {
        try {
            ArrayList<URL> urls = new ArrayList<URL>();
            ClassLoader cl = Environment.class.getClassLoader();
            for (String p : new String[]{"META-INF/naftools.properties", "naftools.properties"}) {
                Enumeration<URL> e = cl.getResources(p);
                while (e.hasMoreElements()) {
                    urls.add(e.nextElement());
                }
            }
            for (URL url : urls) {
                try (InputStreamReader in = new InputStreamReader(url.openStream(), Charset.forName("UTF-8"));){
                    PROPERTIES.load(in);
                    LOGGER.debug("Loaded configuration from '" + url + "'");
                }
            }
        }
        catch (IOException ex) {
            LOGGER.warn("Could not complete loading of configuration from classpath resources", ex);
        }
    }

    private static final class AlignPair<T>
    implements Comparable<AlignPair<?>> {
        final T object1;
        final T object2;
        @Nullable
        Object similarity;

        public AlignPair(T object1, T object2, Object similarity) {
            this.object1 = object1;
            this.object2 = object2;
            this.similarity = similarity;
        }

        @Override
        public int compareTo(AlignPair other) {
            if (this.similarity == null) {
                return other.similarity == null ? 0 : -1;
            }
            if (other.similarity == null) {
                return 1;
            }
            if (this.similarity instanceof Comparable) {
                return ((Comparable)this.similarity).compareTo(other.similarity);
            }
            if (this.similarity instanceof Iterable) {
                return Ordering.natural().lexicographical().compare((Iterable)this.similarity, (Iterable)other.similarity);
            }
            throw new IllegalArgumentException("Could not compare similarities " + this.similarity + ", " + other.similarity);
        }
    }
}

