/*
 * Decompiled with CFR 0.152.
 */
package eu.fbk.utils.eval;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Ordering;
import eu.fbk.utils.core.CommandLine;
import java.io.Serializable;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import javax.annotation.Nullable;

public class RankingScore
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final int maxN;
    private final int numRanking;
    private final int[] numRankings;
    private final double[] precisions;
    private final double mrr;
    private final double ndcg;
    private final double[] ndcgs;
    private final double altNdcg;
    private final double[] altNdcgs;
    private final double map;
    private final double[] maps;

    private RankingScore(int maxN, int numRanking, int[] numRankings, double[] precisions, double mrr, double ndcg, double[] ndcgs, double altNdcg, double[] altNdcgs, double map, double[] maps) {
        this.maxN = maxN;
        this.numRanking = numRanking;
        this.numRankings = numRankings;
        this.precisions = precisions;
        this.mrr = mrr;
        this.ndcg = ndcg;
        this.ndcgs = ndcgs;
        this.altNdcg = altNdcg;
        this.altNdcgs = altNdcgs;
        this.map = map;
        this.maps = maps;
    }

    private void checkNumber(int number) {
        if (number <= 0) {
            throw new IllegalArgumentException("Negative number");
        }
        if (number > this.maxN) {
            throw new IllegalArgumentException("No data for N = " + number + " (Max N: " + this.maxN + ")");
        }
    }

    public static <T> RankingScore evaluate(Iterable<T> ranking, Iterable<T> relevantElements) {
        return RankingScore.evaluator(Iterables.size(ranking)).add(ranking, relevantElements).get();
    }

    public static <T> RankingScore evaluate(Iterable<T> ranking, Map<T, Double> relevances) {
        return RankingScore.evaluator(Iterables.size(ranking)).add(ranking, relevances).get();
    }

    public static RankingScore average(Iterable<RankingScore> scores) {
        int maxN = Integer.MAX_VALUE;
        for (RankingScore score : scores) {
            maxN = Math.min(maxN, score.maxN);
        }
        if (maxN == Integer.MAX_VALUE) {
            throw new IllegalArgumentException("No measure supplied");
        }
        Evaluator evaluator = RankingScore.evaluator(maxN);
        for (RankingScore score : scores) {
            evaluator.add(score);
        }
        return evaluator.get();
    }

    public int getMaxN() {
        return this.maxN;
    }

    public int getNumRankings() {
        return this.numRanking;
    }

    public int getNumRankings(int atNumber) {
        this.checkNumber(atNumber);
        return this.numRankings[atNumber - 1];
    }

    public double getPrecision(int atNumber) {
        this.checkNumber(atNumber);
        return this.precisions[atNumber - 1];
    }

    public double getMRR() {
        return this.mrr;
    }

    public double getNDCG() {
        return this.ndcg;
    }

    public double getNDCG(int atNumber) {
        this.checkNumber(atNumber);
        return this.ndcgs[atNumber - 1];
    }

    public double getAltNDCG() {
        return this.altNdcg;
    }

    public double getAltNDCG(int atNumber) {
        this.checkNumber(atNumber);
        return this.altNdcgs[atNumber - 1];
    }

    public double getMAP() {
        return this.map;
    }

    public double getMAP(int atNumber) {
        this.checkNumber(atNumber);
        return this.maps[atNumber - 1];
    }

    public double get(Measure measure) {
        switch (measure.getType()) {
            case "p": {
                return this.getPrecision(measure.getNumber());
            }
            case "mrr": {
                return this.getMRR();
            }
            case "ndcg": {
                return measure.getNumber() > 0 ? this.getNDCG(measure.getNumber()) : this.getNDCG();
            }
            case "altndcg": {
                return measure.getNumber() > 0 ? this.getAltNDCG(measure.getNumber()) : this.getAltNDCG();
            }
            case "map": {
                return measure.getNumber() > 0 ? this.getMAP(measure.getNumber()) : this.getMAP();
            }
        }
        throw new IllegalArgumentException("Invalid measure " + measure);
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof RankingScore)) {
            return false;
        }
        RankingScore other = (RankingScore)object;
        return this.maxN == other.maxN && this.numRanking == other.numRanking && Arrays.equals(this.numRankings, other.numRankings) && Arrays.equals(this.precisions, other.precisions) && this.mrr == other.mrr && this.ndcg == other.ndcg && Arrays.equals(this.ndcgs, other.ndcgs) && this.map == other.map && Arrays.equals(this.maps, other.maps);
    }

    public int hashCode() {
        return Objects.hash(this.maxN, this.numRanking, Arrays.hashCode(this.numRankings), Arrays.hashCode(this.precisions), this.mrr, this.ndcg, Arrays.hashCode(this.ndcgs), this.map, Arrays.hashCode(this.maps));
    }

    public String toString() {
        int[] ns = new int[30];
        int count = 0;
        int n = 1;
        while (n <= this.maxN) {
            ns[count++] = n;
            if ((n *= 3) > this.maxN) continue;
            ns[count++] = n;
            if ((n = n / 3 * 5) > this.maxN) continue;
            ns[count++] = n;
            n *= 2;
        }
        int maxN = ns[count - 1];
        StringBuilder builder = new StringBuilder();
        for (int i = 0; i < count; ++i) {
            n = ns[i];
            builder.append("p@").append(n).append("=").append(String.format("%.3f", this.getPrecision(n))).append(" ");
        }
        builder.append("mrr=").append(String.format("%.3f", this.getMRR())).append(" ");
        builder.append("ndcg=").append(String.format("%.3f", this.getNDCG())).append(" ");
        builder.append("ndcg@").append(maxN).append("=").append(String.format("%.3f", this.getNDCG(maxN))).append(" ");
        builder.append("map=").append(String.format("%.3f", this.getMAP())).append(" ");
        builder.append("map@").append(maxN).append("=").append(String.format("%.3f", this.getMAP(n))).append(" ");
        builder.append("nr=").append(this.getNumRankings());
        return builder.toString();
    }

    public static Ordering<RankingScore> comparator(final Measure measure, final boolean higherFirst) {
        return new Ordering<RankingScore>(){

            @Override
            public int compare(RankingScore left, RankingScore right) {
                double leftValue = left.get(measure);
                double rightValue = right.get(measure);
                int result = Double.compare(leftValue, rightValue);
                return higherFirst ? -result : result;
            }
        };
    }

    public static Evaluator evaluator(int maxN) {
        return new Evaluator(maxN);
    }

    public static void main(String ... args) {
        try {
            CommandLine cmd = CommandLine.parser().withName("ranking-score").withOption("g", "gold", "specifies the gold relevances FILE", "FILE", CommandLine.Type.FILE_EXISTING, true, false, true).withOption("r", "ranking", "specifies the ranking FILE", "FILE", CommandLine.Type.FILE_EXISTING, true, false, true).withHeader("Evaluates the ranking from a file against the gold relevances in another file. File format: rank_id item1_id[:rel] ... where rel is 1 if omitted").parse(args);
            HashMap rels = Maps.newHashMap();
            for (String string : Files.readAllLines(cmd.getOptionValue("g", Path.class))) {
                String[] tokens = string.split("[\\s+,;]+");
                HashMap<String, Double> map = Maps.newHashMap();
                rels.put(tokens[0], map);
                for (int i = 1; i < tokens.length; ++i) {
                    int j = tokens[i].lastIndexOf(58);
                    if (j < 0) {
                        map.put(tokens[i], 1.0);
                        continue;
                    }
                    map.put(tokens[i].substring(0, j), Double.parseDouble(tokens[i].substring(j + 1)));
                }
            }
            System.out.println("# key\tp@1\tp@3\tp@5\tp@10\tmrr\tndcg\tndcg@10\tmap\tmap@10");
            Evaluator evaluator = RankingScore.evaluator(10);
            for (String line : Files.readAllLines(cmd.getOptionValue("r", Path.class))) {
                String[] tokens = line.split("[\\s+,;]+");
                String key = tokens[0];
                ArrayList<String> ranking = Lists.newArrayList();
                for (int i = 1; i < tokens.length; ++i) {
                    int j = tokens[i].lastIndexOf(58);
                    ranking.add(j < 0 ? tokens[i] : tokens[i].substring(0, i));
                }
                if (!rels.containsKey(key)) {
                    throw new CommandLine.Exception("No gold relevances for key " + key);
                }
                RankingScore s = RankingScore.evaluator(10).add(ranking, (Map)rels.get(key)).get();
                evaluator.add(s);
                System.out.println(key + "\t" + s.getPrecision(1) + "\t" + s.getPrecision(3) + "\t" + s.getPrecision(5) + "\t" + s.getPrecision(10) + "\t" + s.getMRR() + "\t" + s.getNDCG() + "\t" + s.getNDCG(10) + "\t" + s.getMAP() + "\t" + s.getMAP(10));
            }
            RankingScore rankingScore = evaluator.get();
            System.out.println("ALL\t" + rankingScore.getPrecision(1) + "\t" + rankingScore.getPrecision(3) + "\t" + rankingScore.getPrecision(5) + "\t" + rankingScore.getPrecision(10) + "\t" + rankingScore.getMRR() + "\t" + rankingScore.getNDCG() + "\t" + rankingScore.getNDCG(10) + "\t" + rankingScore.getMAP() + "\t" + rankingScore.getMAP(10));
        }
        catch (Throwable ex) {
            CommandLine.fail(ex);
        }
    }

    public static final class Evaluator {
        private int maxN;
        private int numRanking;
        private int[] numRankings;
        private double[] sumPrecision;
        private double sumMRR;
        private double sumNDCG;
        private double[] sumNDCGs;
        private double sumAltNDCG;
        private double[] sumAltNDCGs;
        private double sumMAP;
        private double[] sumMAPs;
        private RankingScore result;

        private Evaluator(int maxN) {
            this.maxN = maxN;
            this.numRanking = 0;
            this.numRankings = new int[maxN];
            this.sumPrecision = new double[maxN];
            this.sumMRR = 0.0;
            this.sumNDCG = 0.0;
            this.sumNDCGs = new double[maxN];
            this.sumAltNDCG = 0.0;
            this.sumAltNDCGs = new double[maxN];
            this.sumMAP = 0.0;
            this.sumMAPs = new double[maxN];
            this.result = null;
        }

        private void shrinkIfNeeded(int maxN) {
            if (maxN < this.maxN) {
                this.maxN = maxN;
                this.numRankings = Arrays.copyOf(this.numRankings, maxN);
                this.sumPrecision = Arrays.copyOf(this.sumPrecision, maxN);
                this.sumNDCGs = Arrays.copyOf(this.sumNDCGs, maxN);
                this.sumAltNDCGs = Arrays.copyOf(this.sumAltNDCGs, maxN);
                this.sumMAPs = Arrays.copyOf(this.sumMAPs, maxN);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private <T> void update(Iterable<T> ranking, Set<T> relItems, @Nullable Map<T, Double> rels) {
            double[] relsSorted = null;
            if (rels != null) {
                relsSorted = new double[rels.size()];
                int i = 0;
                for (Double rel : rels.values()) {
                    relsSorted[i++] = rel;
                }
                Arrays.sort(relsSorted);
            }
            int n = 0;
            int c = 0;
            double mapNum = 0.0;
            double ndcgNum = 0.0;
            double ndcgDen = 0.0;
            double altNdcgNum = 0.0;
            double altNdcgDen = 0.0;
            double ln2 = Math.log(2.0);
            double pn = 0.0;
            Evaluator evaluator = this;
            synchronized (evaluator) {
                ++this.numRanking;
                this.result = null;
                for (T item : ranking) {
                    int r = relItems.contains(item) ? 1 : 0;
                    double f = n == 1 ? 1.0 : ln2 / Math.log(++n);
                    double altF = ln2 / Math.log(n + 1);
                    pn = (double)(c += r) / (double)n;
                    mapNum += pn * (double)r;
                    if (r == 1 && (double)c == 1.0) {
                        this.sumMRR += 1.0 / (double)n;
                    }
                    if (r == 1) {
                        ndcgNum += (rels == null ? 1.0 : rels.get(item)) * f;
                        altNdcgNum += (rels == null ? 1.0 : Math.pow(2.0, rels.get(item)) - 1.0) * altF;
                    }
                    if (n <= relItems.size()) {
                        ndcgDen += (rels == null ? 1.0 : relsSorted[relsSorted.length - n]) * f;
                        altNdcgDen += (rels == null ? 1.0 : Math.pow(2.0, relsSorted[relsSorted.length - n]) - 1.0) * altF;
                    }
                    if (n > this.maxN) continue;
                    int n2 = n - 1;
                    this.numRankings[n2] = this.numRankings[n2] + 1;
                    int n3 = n - 1;
                    this.sumPrecision[n3] = this.sumPrecision[n3] + pn;
                    int n4 = n - 1;
                    this.sumNDCGs[n4] = this.sumNDCGs[n4] + ndcgNum / ndcgDen;
                    int n5 = n - 1;
                    this.sumAltNDCGs[n5] = this.sumAltNDCGs[n5] + altNdcgNum / altNdcgDen;
                    if (relItems.isEmpty()) continue;
                    int n6 = n - 1;
                    this.sumMAPs[n6] = this.sumMAPs[n6] + mapNum / (double)relItems.size();
                }
                int limit = Math.max(this.maxN, relItems.size());
                ++n;
                while (n <= limit) {
                    if (n <= relItems.size()) {
                        double f = n == 1 ? 1.0 : ln2 / Math.log(n);
                        double altF = ln2 / Math.log(n + 1);
                        ndcgDen += (rels == null ? 1.0 : relsSorted[relsSorted.length - n]) * f;
                        altNdcgDen += (rels == null ? 1.0 : Math.pow(2.0, relsSorted[relsSorted.length - n]) - 1.0) * altF;
                    }
                    if (n <= this.maxN) {
                        int n7 = n - 1;
                        this.sumNDCGs[n7] = this.sumNDCGs[n7] + ndcgNum / ndcgDen;
                        int n8 = n - 1;
                        this.sumAltNDCGs[n8] = this.sumAltNDCGs[n8] + altNdcgNum / altNdcgDen;
                        if (!relItems.isEmpty()) {
                            int n9 = n - 1;
                            this.sumMAPs[n9] = this.sumMAPs[n9] + mapNum / (double)relItems.size();
                        }
                    }
                    ++n;
                }
                if (!relItems.isEmpty()) {
                    this.sumNDCG += ndcgNum / ndcgDen;
                    this.sumAltNDCG += altNdcgNum / altNdcgDen;
                    this.sumMAP += mapNum / (double)relItems.size();
                }
            }
        }

        public <T> Evaluator add(Iterable<T> ranking, Iterable<T> relItems) {
            this.update(ranking, relItems instanceof Set ? (ImmutableSet<T>)relItems : ImmutableSet.copyOf(relItems), null);
            return this;
        }

        public <T> Evaluator add(Iterable<T> ranking, Map<T, Double> rels) {
            this.update(ranking, rels.keySet(), rels);
            return this;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Evaluator add(RankingScore score) {
            Evaluator evaluator = this;
            synchronized (evaluator) {
                this.shrinkIfNeeded(score.maxN);
                this.numRanking += score.numRanking;
                this.sumMRR += score.mrr * (double)score.numRanking;
                this.sumNDCG += score.ndcg * (double)score.numRanking;
                this.sumAltNDCG += score.altNdcg * (double)score.numRanking;
                this.sumMAP += score.map * (double)score.numRanking;
                for (int i = 0; i < this.maxN; ++i) {
                    int n = i;
                    this.numRankings[n] = this.numRankings[n] + score.numRankings[i];
                    int n2 = i;
                    this.sumPrecision[n2] = this.sumPrecision[n2] + (score.numRankings[i] == 0 ? 0.0 : score.precisions[i] * (double)score.numRankings[i]);
                    int n3 = i;
                    this.sumNDCGs[n3] = this.sumNDCGs[n3] + score.ndcgs[i] * (double)score.numRanking;
                    int n4 = i;
                    this.sumAltNDCGs[n4] = this.sumAltNDCGs[n4] + score.altNdcgs[i] * (double)score.numRanking;
                    int n5 = i;
                    this.sumMAPs[n5] = this.sumMAPs[n5] + score.maps[i] * (double)score.numRanking;
                }
                this.result = null;
            }
            return this;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Evaluator add(Evaluator evaluator) {
            Evaluator evaluator2 = evaluator;
            synchronized (evaluator2) {
                Evaluator evaluator3 = this;
                synchronized (evaluator3) {
                    this.shrinkIfNeeded(evaluator.maxN);
                    this.numRanking += evaluator.numRanking;
                    this.sumMRR += evaluator.sumMRR;
                    this.sumNDCG += evaluator.sumNDCG;
                    this.sumAltNDCG += evaluator.sumAltNDCG;
                    this.sumMAP += evaluator.sumMAP;
                    for (int i = 0; i < this.maxN; ++i) {
                        int n = i;
                        this.numRankings[n] = this.numRankings[n] + evaluator.numRankings[i];
                        int n2 = i;
                        this.sumPrecision[n2] = this.sumPrecision[n2] + evaluator.sumPrecision[i];
                        int n3 = i;
                        this.sumNDCGs[n3] = this.sumNDCGs[n3] + evaluator.sumNDCGs[i];
                        int n4 = i;
                        this.sumAltNDCGs[n4] = this.sumAltNDCGs[n4] + evaluator.sumAltNDCGs[i];
                        int n5 = i;
                        this.sumMAPs[n5] = this.sumMAPs[n5] + evaluator.sumMAPs[i];
                    }
                    this.result = null;
                }
            }
            return this;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public RankingScore get() {
            Evaluator evaluator = this;
            synchronized (evaluator) {
                if (this.result == null) {
                    double factor = this.numRanking == 0 ? 0.0 : 1.0 / (double)this.numRanking;
                    double mrr = this.sumMRR * factor;
                    double ndcg = this.sumNDCG * factor;
                    double altNdcg = this.sumAltNDCG * factor;
                    double map = this.sumMAP * factor;
                    double[] precisions = new double[this.maxN];
                    double[] ndcgs = new double[this.maxN];
                    double[] altNdcgs = new double[this.maxN];
                    double[] maps = new double[this.maxN];
                    for (int i = 0; i < this.maxN; ++i) {
                        precisions[i] = this.numRankings[i] == 0 ? Double.NaN : this.sumPrecision[i] / (double)this.numRankings[i];
                        ndcgs[i] = this.sumNDCGs[i] * factor;
                        altNdcgs[i] = this.sumAltNDCGs[i] * factor;
                        maps[i] = this.sumMAPs[i] * factor;
                    }
                    this.result = new RankingScore(this.maxN, this.numRanking, (int[])this.numRankings.clone(), precisions, mrr, ndcg, ndcgs, altNdcg, altNdcgs, map, maps);
                }
                return this.result;
            }
        }
    }

    public static final class Measure {
        public static final Measure P1 = new Measure("p", 1);
        public static final Measure P3 = new Measure("p", 3);
        public static final Measure P5 = new Measure("p", 5);
        public static final Measure P10 = new Measure("p", 10);
        public static final Measure MRR = new Measure("mrr", 0);
        public static final Measure NDCG = new Measure("ndcg", 0);
        public static final Measure NDCG10 = new Measure("ndcg", 10);
        public static final Measure ALTNDCG = new Measure("altndcg", 0);
        public static final Measure ALTNDCG10 = new Measure("altndcg", 10);
        public static final Measure MAP = new Measure("map", 0);
        public static final Measure MAP10 = new Measure("map", 10);
        private final String type;
        private final int number;

        private Measure(String type, int number) {
            this.type = type.intern();
            this.number = number;
        }

        public static Measure create(String spec) {
            int index = spec.indexOf(64);
            if (index > 0) {
                String type = spec.substring(0, index).trim().toLowerCase().intern();
                int number = Integer.parseInt(spec.substring(index + 1).trim());
                Preconditions.checkArgument(number > 0);
                Preconditions.checkArgument(type == "p" || type == "ndcg" || type == "altndcg" || type == "map");
                return new Measure(type, number);
            }
            String type = spec.trim().toLowerCase().intern();
            Preconditions.checkArgument(type == "mrr" || type == "ndcg" || type == "altndcg" || type == "map");
            return new Measure(type, 0);
        }

        public String getType() {
            return this.type;
        }

        @Nullable
        public int getNumber() {
            return this.number;
        }

        public boolean equals(Object object) {
            if (object == this) {
                return true;
            }
            if (!(object instanceof Measure)) {
                return false;
            }
            Measure other = (Measure)object;
            return this.type == other.type && this.number == other.number;
        }

        public int hashCode() {
            return Objects.hash(this.type, this.number);
        }

        public String toString() {
            return this.type + (this.number > 0 ? "@" + this.number : "");
        }
    }
}

