/*
 * Decompiled with CFR 0.152.
 */
package eu.fbk.utils.eval;

import java.text.NumberFormat;

public class PrecisionRecallStats {
    protected int tpCount = 0;
    protected int fpCount = 0;
    protected int fnCount = 0;

    public PrecisionRecallStats() {
        this(0, 0, 0);
    }

    public PrecisionRecallStats(int tp, int fp, int fn) {
        this.tpCount = tp;
        this.fpCount = fp;
        this.fnCount = fn;
    }

    public int getTP() {
        return this.tpCount;
    }

    public int getFP() {
        return this.fpCount;
    }

    public int getFN() {
        return this.fnCount;
    }

    public void addTP(int count) {
        this.tpCount += count;
    }

    public void incrementTP() {
        this.addTP(1);
    }

    public void addFP(int count) {
        this.fpCount += count;
    }

    public void incrementFP() {
        this.addFP(1);
    }

    public void addFN(int count) {
        this.fnCount += count;
    }

    public void incrementFN() {
        this.addFN(1);
    }

    public void addCounts(PrecisionRecallStats prs) {
        this.addTP(prs.getTP());
        this.addFP(prs.getFP());
        this.addFN(prs.getFN());
    }

    public double getPrecision() {
        if (this.tpCount == 0 && this.fpCount == 0) {
            return 1.0;
        }
        return (double)this.tpCount / (double)(this.tpCount + this.fpCount);
    }

    public String getPrecisionDescription(int numDigits) {
        NumberFormat nf = NumberFormat.getNumberInstance();
        nf.setMaximumFractionDigits(numDigits);
        return nf.format(this.getPrecision()) + "  (" + this.tpCount + "/" + (this.tpCount + this.fpCount) + ")";
    }

    public double getRecall() {
        if (this.tpCount == 0 && this.fnCount == 0) {
            return 1.0;
        }
        return (double)this.tpCount / (double)(this.tpCount + this.fnCount);
    }

    public String getRecallDescription(int numDigits) {
        NumberFormat nf = NumberFormat.getNumberInstance();
        nf.setMaximumFractionDigits(numDigits);
        return nf.format(this.getRecall()) + "  (" + this.tpCount + "/" + (this.tpCount + this.fnCount) + ")";
    }

    public double getFMeasure() {
        return this.getFMeasure(0.5);
    }

    public double getFMeasure(double alpha) {
        double pr = this.getPrecision();
        double re = this.getRecall();
        if (pr == 0.0 || re == 0.0) {
            return 0.0;
        }
        return 1.0 / (alpha / pr + (1.0 - alpha) / re);
    }

    public String getF1Description(int numDigits) {
        NumberFormat nf = NumberFormat.getNumberInstance();
        nf.setMaximumFractionDigits(numDigits);
        return nf.format(this.getFMeasure());
    }

    public String toString() {
        return "PrecisionRecallStats[tp=" + this.getTP() + ",fp=" + this.getFP() + ",fn=" + this.getFN() + "]";
    }

    public String toString(int numDigits) {
        return "PrecisionRecallStats[tp=" + this.getTP() + ",fp=" + this.getFP() + ",fn=" + this.getFN() + ",p=" + this.getPrecisionDescription(numDigits) + ",r=" + this.getRecallDescription(numDigits) + ",f1=" + this.getF1Description(numDigits) + "]";
    }
}

