/*
 * Decompiled with CFR 0.152.
 */
package eu.fbk.utils.eval;

import java.text.DecimalFormat;
import java.util.Arrays;
import java.util.Random;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ApproximateRandomization {
    private static final Logger LOGGER = LoggerFactory.getLogger(ApproximateRandomization.class);
    private static DecimalFormat formatter = new DecimalFormat("###,###.####");

    private static void swap(double[] y, double[] z, Random rdm) {
        int count = 0;
        for (int i = 0; i < y.length; ++i) {
            double p = rdm.nextDouble();
            if (!(p < 0.5)) continue;
            double t = y[i];
            y[i] = z[i];
            z[i] = t;
            ++count;
        }
    }

    static double calculateScore(double[] tmp) {
        double sum = 0.0;
        for (double v : tmp) {
            sum += v;
        }
        return sum / (double)tmp.length;
    }

    static double test(int iterations, double[] a, double[] b) {
        double bs = ApproximateRandomization.calculateScore(a);
        double ps = ApproximateRandomization.calculateScore(b);
        double d = Math.abs(ps - bs);
        LOGGER.debug("Original score bs, ps, d: " + formatter.format(bs * 100.0) + "%, " + formatter.format(ps * 100.0) + "%, " + formatter.format(d * 100.0) + "%");
        double p = 0.0;
        double mean = 0.0;
        double variance = 0.0;
        double sum = 0.0;
        double ssum = 0.0;
        int c = 0;
        for (int i = 0; i < iterations; ++i) {
            double[] x = new double[a.length];
            double[] y = new double[b.length];
            System.arraycopy(a, 0, x, 0, a.length);
            System.arraycopy(b, 0, y, 0, b.length);
            ApproximateRandomization.swap(x, y, new Random(i * 123));
            bs = ApproximateRandomization.calculateScore(x);
            ps = ApproximateRandomization.calculateScore(y);
            double di = Math.abs(ps - bs);
            sum += di;
            ssum += Math.pow(di, 2.0);
            if (!(di >= d)) continue;
            ++c;
        }
        mean = sum / (double)iterations;
        variance = ((double)iterations * ssum - Math.pow(sum, 2.0)) / (double)iterations * (double)(iterations - 1);
        p = (double)(c + 1) / (double)(iterations + 1);
        LOGGER.debug("Mean: " + mean + ", " + Math.sqrt(variance));
        LOGGER.debug(p + " = (" + c + " + 1) / (" + iterations + " + 1)");
        return p;
    }

    public static void main(String[] args) {
        double[] a = new double[]{0.1, 0.2, 0.4, 0.34, 0.7};
        double[] b = new double[]{1.2, 1.1, 1.89, 1.7, 1.99};
        ApproximateRandomization.swap(a, b, new Random(1234L));
        System.out.println(Arrays.toString(a));
        System.out.println(Arrays.toString(b));
    }
}

