/*
 * Decompiled with CFR 0.152.
 */
package eu.fbk.utils.core.io;

import java.io.File;
import java.io.FileFilter;
import java.util.ArrayList;
import java.util.Stack;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class FolderScanner {
    static Logger logger = LoggerFactory.getLogger(FolderScanner.class);
    private File root;
    private Stack<File> stack;
    private FileFilter filter;

    public FolderScanner(File root) {
        this.root = root;
        this.stack = new Stack();
        this.stack.push(root);
    }

    public void setFiler(FileFilter filter) {
        this.filter = filter;
    }

    public void setFilter(FileFilter filter) {
        this.filter = filter;
    }

    public boolean hasNext() {
        return !this.stack.empty();
    }

    public Object[] next() {
        File dir = null;
        if (!this.stack.empty()) {
            ArrayList<File> res = new ArrayList<File>();
            try {
                dir = this.stack.pop();
                File[] ls = null;
                ls = this.filter == null ? dir.listFiles() : dir.listFiles(this.filter);
                for (int i = 0; i < ls.length; ++i) {
                    if (ls[i].isFile()) {
                        res.add(ls[i]);
                        continue;
                    }
                    if (!ls[i].isDirectory()) continue;
                    this.stack.push(ls[i]);
                }
            }
            catch (Exception e) {
                logger.error("Exception thrown \"FolderScanner.next\" " + e);
            }
            return res.toArray();
        }
        return null;
    }

    public static void main(String[] args) throws Exception {
        if (args.length != 1) {
            System.out.println("Usage: java -mx512M org.fbk.it.hlt.jlsi.util.FolderScanner in");
            System.exit(1);
        }
        FolderScanner fs = new FolderScanner(new File(args[0]));
        int count = 0;
        while (fs.hasNext()) {
            Object[] files = fs.next();
            System.out.println(count++ + " : " + files.length);
            for (int i = 0; i < files.length; ++i) {
                System.out.println(files[i]);
            }
        }
    }
}

