/*
 * Decompiled with CFR 0.152.
 */
package eu.fbk.utils.core.core;

import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;

public abstract class IndexSet<E>
implements Iterable<E>,
Collection<E>,
Set<E> {
    protected Map<E, Entry> map;
    private int count;

    public IndexSet(int from) {
        this.count = from;
    }

    public IndexSet() {
        this(0);
    }

    @Override
    public boolean isEmpty() {
        return this.map.isEmpty();
    }

    @Override
    public boolean remove(Object o) {
        return this.map.remove(o) == null;
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        Iterator<?> it = c.iterator();
        boolean b = true;
        while (it.hasNext()) {
            b &= this.remove(it.next());
        }
        return b;
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        Iterator<E> it = this.iterator();
        boolean b = true;
        while (it.hasNext()) {
            E e = it.next();
            if (c.contains(e)) continue;
            b &= this.remove(e);
        }
        return b;
    }

    @Override
    public boolean addAll(Collection<? extends E> c) {
        Iterator<E> it = c.iterator();
        boolean b = true;
        while (it.hasNext()) {
            b &= this.add(it.next());
        }
        return b;
    }

    public void addAll(Set<E> set) {
        Iterator<E> it = set.iterator();
        while (it.hasNext()) {
            this.add(it.next());
        }
    }

    @Override
    public boolean add(E o) {
        Entry entry = this.map.get(o);
        if (entry == null) {
            entry = new Entry(this.count++, 1);
            this.map.put(o, entry);
            return true;
        }
        entry.inc();
        return false;
    }

    @Override
    public boolean contains(Object o) {
        Entry e = this.map.get(o);
        return e != null;
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        Iterator<E> it = this.iterator();
        boolean b = true;
        while (it.hasNext()) {
            b &= c.contains(it.next());
        }
        return b;
    }

    @Override
    public Iterator<E> iterator() {
        return this.map.keySet().iterator();
    }

    @Override
    public int size() {
        return this.map.size();
    }

    public int getIndex(E o) {
        Entry entry = this.map.get(o);
        if (entry == null) {
            return -1;
        }
        return entry.getIndex();
    }

    public Set<E> keySet() {
        return this.map.keySet();
    }

    @Override
    public void clear() {
        this.count = 0;
        this.map.clear();
    }

    @Override
    public Object[] toArray() {
        return this.map.keySet().toArray();
    }

    @Override
    public <T> T[] toArray(T[] a) {
        return this.map.keySet().toArray(a);
    }

    public String toString1() {
        StringBuffer sb = new StringBuffer();
        Object o2 = null;
        Entry entry = null;
        for (Object o2 : this.map.keySet()) {
            entry = this.map.get(o2);
            sb.append((Object)o2);
            sb.append("\t");
            sb.append(entry);
            sb.append("\n");
        }
        return sb.toString();
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        TreeMap<Integer, String> smap = new TreeMap<Integer, String>();
        Object o2 = null;
        Entry entry = null;
        for (Object o2 : this.map.keySet()) {
            entry = this.map.get(o2);
            smap.put(entry.getFreq(), o2 + "\t" + entry);
        }
        Iterator it1 = smap.keySet().iterator();
        int freq = 0;
        while (it1.hasNext()) {
            freq = (Integer)it1.next();
            sb.append((String)smap.get(freq));
            sb.append("\n");
        }
        return sb.toString();
    }

    class Entry {
        private int index;
        private int freq;

        Entry(int index, int freq) {
            this.index = index;
            this.freq = freq;
        }

        public int getIndex() {
            return this.index;
        }

        public int getFreq() {
            return this.freq;
        }

        public String toString() {
            return this.index + "\t" + this.freq;
        }

        public void inc() {
            ++this.freq;
        }
    }
}

