/*
 * Decompiled with CFR 0.152.
 */
package eu.fbk.utils.core;

import java.io.Reader;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;

public abstract class StaxParser {
    private static XMLInputFactory STAX_FACTORY = XMLInputFactory.newInstance();
    private XMLStreamReader reader;
    private int targetLevel;
    private int actualLevel;

    protected StaxParser(Reader reader) {
        try {
            this.reader = STAX_FACTORY.createXMLStreamReader(reader);
            this.targetLevel = 0;
            this.actualLevel = 0;
        }
        catch (XMLStreamException ex) {
            throw new Error("Unexpected exception (!)", ex);
        }
    }

    protected final void leave() throws XMLStreamException {
        --this.targetLevel;
        while (this.actualLevel > this.targetLevel && this.reader.hasNext()) {
            int event = this.reader.next();
            if (event == 1) {
                ++this.actualLevel;
                continue;
            }
            if (event != 2) continue;
            --this.actualLevel;
        }
    }

    protected final void enter(String element) throws XMLStreamException {
        if (!this.tryEnter(element)) {
            throw new XMLStreamException("Expected element " + element);
        }
    }

    protected final boolean tryEnter(String element) throws XMLStreamException {
        if (this.actualLevel > this.targetLevel && (element == null || this.reader.getLocalName().equals(element))) {
            ++this.targetLevel;
            return true;
        }
        while (this.actualLevel >= this.targetLevel && this.reader.hasNext()) {
            int event = this.reader.next();
            if (event == 1) {
                ++this.actualLevel;
                if (this.actualLevel != this.targetLevel + 1 || element != null && !this.reader.getLocalName().equals(element)) continue;
                ++this.targetLevel;
                return true;
            }
            if (event != 2) continue;
            --this.actualLevel;
        }
        return false;
    }

    protected final boolean tryEnterNext(String element) throws XMLStreamException {
        if (this.actualLevel > this.targetLevel && this.reader.getLocalName().equals(element)) {
            ++this.targetLevel;
            return true;
        }
        while (this.actualLevel == this.targetLevel && this.reader.hasNext()) {
            int event = this.reader.next();
            if (event == 1) {
                ++this.actualLevel;
                if (!this.reader.getLocalName().equals(element)) continue;
                ++this.targetLevel;
                return true;
            }
            if (event != 2) continue;
            --this.actualLevel;
        }
        return false;
    }

    protected final String attribute(String name) {
        return this.reader.getAttributeValue("", name);
    }

    protected final String content() throws XMLStreamException {
        StringBuilder builder = new StringBuilder();
        while (this.actualLevel >= this.targetLevel && this.reader.hasNext()) {
            int event = this.reader.next();
            if (event == 4 || event == 12) {
                builder.append(this.reader.getText());
                continue;
            }
            if (event == 1) {
                ++this.actualLevel;
                continue;
            }
            if (event != 2) continue;
            --this.actualLevel;
        }
        return builder.toString();
    }

    static {
        STAX_FACTORY.setProperty("javax.xml.stream.supportDTD", false);
    }
}

