/*
 * Decompiled with CFR 0.152.
 */
package eu.fbk.utils.core;

import java.io.IOException;
import java.io.Serializable;

public final class Hash
implements Serializable,
Comparable<Hash> {
    private static final long serialVersionUID = 1L;
    private final long high;
    private final long low;

    private Hash(long high, long low) {
        this.high = high;
        this.low = low;
    }

    public static Hash combine(Hash ... hashes) {
        if (hashes.length == 1) {
            return hashes[0];
        }
        long hi = 0L;
        long lo = 0L;
        for (Hash hash : hashes) {
            hi ^= hash.getHigh() + -1640531527L + (hi << 6) + (hi >> 2);
            lo ^= hash.getLow() + -1640531527L + (lo << 6) + (lo >> 2);
        }
        return Hash.fromLongs(hi, lo);
    }

    public static Hash fromLongs(long high, long low) {
        return new Hash(high, low);
    }

    public static Hash murmur3(CharSequence ... args) {
        long h1 = 0L;
        long h2 = 0L;
        int length = 0;
        long l1 = 0L;
        long l2 = 0L;
        int index = 0;
        long cur = 0L;
        for (int i = 0; i < args.length; ++i) {
            boolean lastArg = i == args.length - 1;
            CharSequence arg = args[i];
            for (int j = 0; j < arg.length(); ++j) {
                long c = (long)arg.charAt(j) & 0xFFFFL;
                cur |= c << index % 4 * 16;
                boolean process = false;
                if (lastArg && j == arg.length() - 1) {
                    l1 = index <= 3 ? cur : l1;
                    l2 = index > 3 ? cur : l2;
                    cur = 0L;
                    process = true;
                } else if (index == 3) {
                    l1 = cur;
                    cur = 0L;
                } else if (index == 7) {
                    l2 = cur;
                    cur = 0L;
                    process = true;
                }
                if (process) {
                    l1 *= -8663945395140668459L;
                    l1 = Long.rotateLeft(l1, 31);
                    h1 ^= (l1 *= 5545529020109919103L);
                    h1 = Long.rotateLeft(h1, 27);
                    h1 += h2;
                    h1 = h1 * 5L + 1390208809L;
                    l2 *= 5545529020109919103L;
                    l2 = Long.rotateLeft(l2, 33);
                    h2 ^= (l2 *= -8663945395140668459L);
                    h2 = Long.rotateLeft(h2, 31);
                    h2 += h1;
                    h2 = h2 * 5L + 944331445L;
                    length += 16;
                    l1 = 0L;
                    l2 = 0L;
                    index = 0;
                    process = false;
                    continue;
                }
                ++index;
            }
        }
        h1 ^= (long)length;
        h1 += (h2 ^= (long)length);
        h2 += h1;
        h1 ^= h1 >>> 33;
        h1 *= -49064778989728563L;
        h1 ^= h1 >>> 33;
        h1 *= -4265267296055464877L;
        h1 ^= h1 >>> 33;
        h2 ^= h2 >>> 33;
        h2 *= -49064778989728563L;
        h2 ^= h2 >>> 33;
        h2 *= -4265267296055464877L;
        h2 ^= h2 >>> 33;
        h1 += h2;
        return new Hash(h1, h2 += h1);
    }

    public long getHigh() {
        return this.high;
    }

    public long getLow() {
        return this.low;
    }

    @Override
    public int compareTo(Hash other) {
        int result = Long.compare(this.high, other.high);
        if (result == 0) {
            result = Long.compare(this.low, other.low);
        }
        return result;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof Hash)) {
            return false;
        }
        Hash other = (Hash)object;
        return this.low == other.low && this.high == other.high;
    }

    public int hashCode() {
        int hh = (int)(this.high >>> 32);
        int hl = (int)this.high;
        int lh = (int)(this.low >>> 32);
        int ll = (int)this.low;
        return ((hh * 37 + hl) * 37 + lh) * 37 + ll;
    }

    public void toString(Appendable out) throws IOException {
        Hash.toStringHelper(out, this.high);
        Hash.toStringHelper(out, this.low);
    }

    public String toString() {
        try {
            StringBuilder builder = new StringBuilder(22);
            this.toString(builder);
            return builder.toString();
        }
        catch (IOException ex) {
            throw new Error("Unexpected error (!)", ex);
        }
    }

    private static void toStringHelper(Appendable out, long l) throws IOException {
        for (int i = 60; i >= 0; i -= 6) {
            int n = (int)(l >>> i) & 0x3F;
            if (n < 26) {
                out.append((char)(65 + n));
                continue;
            }
            if (n < 52) {
                out.append((char)(71 + n));
                continue;
            }
            if (n < 62) {
                out.append((char)(n - 4));
                continue;
            }
            if (n == 62) {
                out.append('_');
                continue;
            }
            out.append('-');
        }
    }
}

