/*
 * Decompiled with CFR 0.152.
 */
package eu.fbk.utils.core;

import java.io.Serializable;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;

public class FrequencyHashSet<K>
implements Serializable {
    private HashMap<K, Integer> support = new HashMap();

    static <K, V extends Comparable<? super V>> SortedSet<Map.Entry<K, V>> entriesSortedByValues(Map<K, V> map) {
        TreeSet<Map.Entry<K, V>> sortedEntries = new TreeSet<Map.Entry<K, V>>(new Comparator<Map.Entry<K, V>>(){

            @Override
            public int compare(Map.Entry<K, V> e1, Map.Entry<K, V> e2) {
                int res = ((Comparable)e2.getValue()).compareTo(e1.getValue());
                return res != 0 ? res : 1;
            }
        });
        sortedEntries.addAll(map.entrySet());
        return sortedEntries;
    }

    public SortedSet<Map.Entry<K, Integer>> getSorted() {
        return FrequencyHashSet.entriesSortedByValues(this.support);
    }

    public LinkedHashMap<K, Integer> getLinked() {
        SortedSet<Map.Entry<K, Integer>> sorted = FrequencyHashSet.entriesSortedByValues(this.support);
        LinkedHashMap temp = new LinkedHashMap();
        for (Object e : sorted) {
            Map.Entry entry = (Map.Entry)e;
            temp.put(entry.getKey(), (Integer)entry.getValue());
        }
        return temp;
    }

    public void add(K o, int quantity) {
        int count = this.support.containsKey(o) ? this.support.get(o) + quantity : quantity;
        this.support.put(o, count);
    }

    public FrequencyHashSet<K> clone() {
        FrequencyHashSet<K> ret = new FrequencyHashSet<K>();
        for (K k : this.support.keySet()) {
            ret.add(k, this.support.get(k));
        }
        return ret;
    }

    public void addAll(Collection<K> collection) {
        for (K el : collection) {
            this.add(el);
        }
    }

    public void addAll(FrequencyHashSet<K> frequencyHashSet) {
        for (K el : frequencyHashSet.keySet()) {
            this.add(el, frequencyHashSet.get(el));
        }
    }

    public void remove(K o) {
        this.support.remove(o);
    }

    public void add(K o) {
        this.add(o, 1);
    }

    public int size() {
        return this.support.size();
    }

    public K mostFrequent() {
        Iterator<K> it = this.support.keySet().iterator();
        Integer max = null;
        K o = null;
        while (it.hasNext()) {
            K index = it.next();
            if (max != null && this.support.get(index) <= max) continue;
            o = index;
            max = this.support.get(index);
        }
        return o;
    }

    public Set<K> keySet() {
        return this.support.keySet();
    }

    public Integer get(K o) {
        return this.support.get(o);
    }

    public Integer getZero(K o) {
        return this.support.get(o) != null ? this.support.get(o) : Integer.valueOf(0);
    }

    public Integer sum() {
        int total = 0;
        for (K key : this.support.keySet()) {
            total += this.support.get(key).intValue();
        }
        return total;
    }

    public Set<K> keySetWithLimit(int limit) {
        HashSet<K> ret = new HashSet<K>();
        for (K key : this.support.keySet()) {
            int value = this.support.get(key);
            if (value < limit) continue;
            ret.add(key);
        }
        return ret;
    }

    public String toString() {
        return this.support.toString();
    }
}

