/*
 * Decompiled with CFR 0.152.
 */
package eu.fbk.utils.core;

import java.io.File;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import javax.annotation.Nullable;

public class Conversion {
    @Nullable
    public static <T> T convert(@Nullable Object object, Class<T> clazz) throws IllegalArgumentException {
        if (object == null) {
            Objects.requireNonNull(clazz);
            return null;
        }
        if (clazz.isInstance(object)) {
            return (T)object;
        }
        Object result = Conversion.convertObject(object, clazz);
        if (result != null) {
            return (T)result;
        }
        throw new IllegalArgumentException("Unsupported conversion of " + object + " to " + clazz);
    }

    @Nullable
    private static Object convertObject(Object object, Class<?> clazz) {
        if (object instanceof String) {
            return Conversion.convertString((String)object, clazz);
        }
        if (object instanceof Number) {
            return Conversion.convertNumber((Number)object, clazz);
        }
        if (object instanceof Boolean) {
            return Conversion.convertBoolean((Boolean)object, clazz);
        }
        if (object instanceof Enum) {
            return Conversion.convertEnum((Enum)object, clazz);
        }
        if (object instanceof File) {
            return Conversion.convertFile((File)object, clazz);
        }
        return null;
    }

    @Nullable
    private static Object convertBoolean(Boolean bool, Class<?> clazz) {
        if (clazz == Boolean.class || clazz == Boolean.TYPE) {
            return bool;
        }
        if (clazz.isAssignableFrom(String.class)) {
            return bool.toString();
        }
        return null;
    }

    @Nullable
    private static Object convertString(String string, Class<?> clazz) {
        if (clazz.isInstance(string)) {
            return string;
        }
        if (clazz == Boolean.class || clazz == Boolean.TYPE) {
            return Boolean.valueOf(string);
        }
        if (clazz == Integer.class || clazz == Integer.TYPE) {
            return (int)Conversion.toLong(string);
        }
        if (clazz == Long.class || clazz == Long.TYPE) {
            return Conversion.toLong(string);
        }
        if (clazz == Double.class || clazz == Double.TYPE) {
            return Double.valueOf(string);
        }
        if (clazz == Float.class || clazz == Float.TYPE) {
            return Float.valueOf(string);
        }
        if (clazz == Short.class || clazz == Short.TYPE) {
            return (short)Conversion.toLong(string);
        }
        if (clazz == Byte.class || clazz == Byte.TYPE) {
            return (byte)Conversion.toLong(string);
        }
        if (clazz == BigDecimal.class) {
            return new BigDecimal(string);
        }
        if (clazz == BigInteger.class) {
            return new BigInteger(string);
        }
        if (clazz == AtomicInteger.class) {
            return new AtomicInteger(Integer.parseInt(string));
        }
        if (clazz == AtomicLong.class) {
            return new AtomicLong(Long.parseLong(string));
        }
        if (clazz == Character.class || clazz == Character.TYPE) {
            return string.isEmpty() ? null : Character.valueOf(string.charAt(0));
        }
        if (clazz.isEnum()) {
            for (Object constant : clazz.getEnumConstants()) {
                if (!string.equalsIgnoreCase(((Enum)constant).name())) continue;
                return constant;
            }
            throw new IllegalArgumentException("Illegal " + clazz.getSimpleName() + " constant: " + string);
        }
        if (clazz == File.class) {
            return new File(string);
        }
        return null;
    }

    @Nullable
    private static Object convertNumber(Number number, Class<?> clazz) {
        if (clazz.isAssignableFrom(String.class)) {
            return number.toString();
        }
        if (clazz == Integer.class || clazz == Integer.TYPE) {
            return number.intValue();
        }
        if (clazz == Long.class || clazz == Long.TYPE) {
            return number.longValue();
        }
        if (clazz == Double.class || clazz == Double.TYPE) {
            return number.doubleValue();
        }
        if (clazz == Float.class || clazz == Float.TYPE) {
            return Float.valueOf(number.floatValue());
        }
        if (clazz == Short.class || clazz == Short.TYPE) {
            return number.shortValue();
        }
        if (clazz == Byte.class || clazz == Byte.TYPE) {
            return number.byteValue();
        }
        if (clazz == BigDecimal.class) {
            return Conversion.toBigDecimal(number);
        }
        if (clazz == BigInteger.class) {
            return Conversion.toBigInteger(number);
        }
        if (clazz == AtomicInteger.class) {
            return new AtomicInteger(number.intValue());
        }
        if (clazz == AtomicLong.class) {
            return new AtomicLong(number.longValue());
        }
        return null;
    }

    @Nullable
    private static Object convertEnum(Enum<?> constant, Class<?> clazz) {
        if (clazz.isInstance(constant)) {
            return constant;
        }
        if (clazz.isAssignableFrom(String.class)) {
            return constant.name();
        }
        return null;
    }

    @Nullable
    private static Object convertFile(File file, Class<?> clazz) {
        if (clazz.isInstance(file)) {
            return clazz.cast(file);
        }
        if (clazz.isAssignableFrom(String.class)) {
            return file.getAbsolutePath();
        }
        return null;
    }

    private static BigDecimal toBigDecimal(Number number) {
        if (number instanceof BigDecimal) {
            return (BigDecimal)number;
        }
        if (number instanceof BigInteger) {
            return new BigDecimal((BigInteger)number);
        }
        if (number instanceof Double || number instanceof Float) {
            double value = number.doubleValue();
            return Double.isInfinite(value) || Double.isNaN(value) ? null : new BigDecimal(value);
        }
        return new BigDecimal(number.longValue());
    }

    private static BigInteger toBigInteger(Number number) {
        if (number instanceof BigInteger) {
            return (BigInteger)number;
        }
        if (number instanceof BigDecimal) {
            return ((BigDecimal)number).toBigInteger();
        }
        if (number instanceof Double || number instanceof Float) {
            return new BigDecimal(number.doubleValue()).toBigInteger();
        }
        return BigInteger.valueOf(number.longValue());
    }

    private static long toLong(String string) {
        long multiplier = 1L;
        char c = string.charAt(string.length() - 1);
        if (c == 'k' || c == 'K') {
            multiplier = 1024L;
        } else if (c == 'm' || c == 'M') {
            multiplier = 0x100000L;
        } else if (c == 'g' || c == 'G') {
            multiplier = 0x40000000L;
        }
        return Long.parseLong(multiplier == 1L ? string : string.substring(0, string.length() - 1)) * multiplier;
    }
}

