/*
 * Decompiled with CFR 0.152.
 */
package eu.fbk.utils.mylibsvm;

import eu.fbk.utils.mylibsvm.svm;
import eu.fbk.utils.mylibsvm.svm_model;
import eu.fbk.utils.mylibsvm.svm_node;
import eu.fbk.utils.mylibsvm.svm_parameter;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.util.StringTokenizer;
import java.util.regex.Pattern;
import org.apache.log4j.Logger;
import org.apache.log4j.PropertyConfigurator;

public class MySVM
extends svm {
    static Logger logger = Logger.getLogger((String)MySVM.class.getName());
    static Pattern spacePattern = Pattern.compile(" ");
    static Pattern colonPattern = Pattern.compile(":");

    private static double atof(String s) {
        return Double.valueOf(s);
    }

    private static int atoi(String s) {
        return Integer.parseInt(s);
    }

    public static void my_svm_save_model(OutputStream output, svm_model model) throws IOException {
        int i;
        logger.debug((Object)"MySVM.my_svm_save_model");
        DataOutputStream fp = new DataOutputStream(new BufferedOutputStream(output));
        svm_parameter param = model.param;
        fp.writeInt(param.svm_type);
        int nr_class = model.nr_class;
        int l = model.l;
        fp.writeInt(nr_class);
        fp.writeInt(l);
        logger.debug((Object)("MySVM.svm_save_model.nr_class " + nr_class));
        logger.debug((Object)("MySVM.svm_save_model.total_sv " + l));
        for (i = 0; i < nr_class * (nr_class - 1) / 2; ++i) {
            fp.writeDouble(model.rho[i]);
        }
        if (model.label != null) {
            for (i = 0; i < nr_class; ++i) {
                fp.writeInt(model.label[i]);
                logger.debug((Object)("MySVM.svm_save_model.label[" + i + "] = " + model.label[i]));
            }
        }
        if (model.nSV != null) {
            for (i = 0; i < nr_class; ++i) {
                fp.writeInt(model.nSV[i]);
                logger.debug((Object)("MySVM.svm_save_model.label[" + i + "] = " + model.nSV[i]));
            }
        }
        double[][] sv_coef = model.sv_coef;
        svm_node[][] SV = model.SV;
        for (int i2 = 0; i2 < l; ++i2) {
            for (int j = 0; j < nr_class - 1; ++j) {
                fp.writeDouble(sv_coef[j][i2]);
            }
            svm_node[] p = SV[i2];
            fp.writeInt(p.length);
            for (int j = 0; j < p.length; ++j) {
                fp.writeInt(p[j].index);
                fp.writeDouble(p[j].value);
            }
        }
        fp.close();
    }

    public static void my_svm_save_prob_model(OutputStream output, svm_model model) throws IOException {
        int i;
        int i2;
        logger.debug((Object)"MySVM.my_svm_save_prob_model");
        DataOutputStream fp = new DataOutputStream(new BufferedOutputStream(output));
        svm_parameter param = model.param;
        fp.writeInt(param.svm_type);
        int nr_class = model.nr_class;
        int l = model.l;
        fp.writeInt(nr_class);
        fp.writeInt(l);
        logger.debug((Object)("MySVM.my_svm_save_prob_model.nr_class " + nr_class));
        logger.debug((Object)("MySVM.my_svm_save_prob_model.total_sv " + l));
        for (i2 = 0; i2 < nr_class * (nr_class - 1) / 2; ++i2) {
            fp.writeDouble(model.rho[i2]);
        }
        if (model.label != null) {
            for (i2 = 0; i2 < nr_class; ++i2) {
                fp.writeInt(model.label[i2]);
                logger.debug((Object)("MySVM.svm_save_model.label[" + i2 + "] = " + model.label[i2]));
            }
        }
        if (model.nSV != null) {
            for (i2 = 0; i2 < nr_class; ++i2) {
                fp.writeInt(model.nSV[i2]);
                logger.debug((Object)("MySVM.my_svm_save_prob_model.label[" + i2 + "] = " + model.nSV[i2]));
            }
        }
        double[][] sv_coef = model.sv_coef;
        svm_node[][] SV = model.SV;
        for (i = 0; i < l; ++i) {
            for (int j = 0; j < nr_class - 1; ++j) {
                fp.writeDouble(sv_coef[j][i]);
            }
            svm_node[] p = SV[i];
            fp.writeInt(p.length);
            for (int j = 0; j < p.length; ++j) {
                fp.writeInt(p[j].index);
                fp.writeDouble(p[j].value);
            }
        }
        if (model.probA != null) {
            for (i = 0; i < nr_class * (nr_class - 1) / 2; ++i) {
                fp.writeDouble(model.probA[i]);
            }
        }
        if (model.probB != null) {
            for (i = 0; i < nr_class * (nr_class - 1) / 2; ++i) {
                fp.writeDouble(model.probB[i]);
            }
        }
        fp.close();
    }

    public static svm_model my_svm_load_model(InputStream input) throws IOException {
        int i;
        svm_parameter param;
        svm_model model = new svm_model();
        model.param = param = new svm_parameter();
        model.rho = null;
        model.probA = null;
        model.probB = null;
        model.label = null;
        model.nSV = null;
        DataInputStream dis = new DataInputStream(new BufferedInputStream(input));
        param.svm_type = dis.readInt();
        param.kernel_type = 0;
        model.nr_class = dis.readInt();
        model.l = dis.readInt();
        model.param = param;
        model.rho = new double[model.nr_class * (model.nr_class - 1) / 2];
        for (i = 0; i < model.nr_class * (model.nr_class - 1) / 2; ++i) {
            model.rho[i] = dis.readDouble();
        }
        model.label = new int[model.nr_class];
        for (i = 0; i < model.nr_class; ++i) {
            model.label[i] = dis.readInt();
        }
        model.nSV = new int[model.nr_class];
        for (i = 0; i < model.nr_class; ++i) {
            model.nSV[i] = dis.readInt();
        }
        model.sv_coef = new double[model.nr_class - 1][model.l];
        svm_node[][] SV = model.SV;
        model.SV = new svm_node[model.l][];
        for (int i2 = 0; i2 < model.l; ++i2) {
            for (int j = 0; j < model.nr_class - 1; ++j) {
                model.sv_coef[j][i2] = dis.readDouble();
            }
            int s = dis.readInt();
            svm_node[] p = new svm_node[s];
            for (int j = 0; j < p.length; ++j) {
                p[j] = new svm_node();
                p[j].index = dis.readInt();
                p[j].value = dis.readDouble();
            }
            model.SV[i2] = p;
        }
        dis.close();
        return model;
    }

    public static svm_model my_svm_load_prob_model(InputStream input) throws IOException {
        int i;
        int i2;
        svm_parameter param;
        logger.debug((Object)"MySVM.my_svm_load_prob_model");
        svm_model model = new svm_model();
        model.param = param = new svm_parameter();
        model.rho = null;
        model.probA = null;
        model.probB = null;
        model.label = null;
        model.nSV = null;
        DataInputStream dis = new DataInputStream(new BufferedInputStream(input));
        param.svm_type = dis.readInt();
        param.kernel_type = 0;
        model.nr_class = dis.readInt();
        model.l = dis.readInt();
        model.param = param;
        int m = model.nr_class * (model.nr_class - 1) / 2;
        model.rho = new double[m];
        for (i2 = 0; i2 < m; ++i2) {
            model.rho[i2] = dis.readDouble();
        }
        model.label = new int[model.nr_class];
        for (i2 = 0; i2 < model.nr_class; ++i2) {
            model.label[i2] = dis.readInt();
        }
        model.nSV = new int[model.nr_class];
        for (i2 = 0; i2 < model.nr_class; ++i2) {
            model.nSV[i2] = dis.readInt();
        }
        model.sv_coef = new double[model.nr_class - 1][model.l];
        svm_node[][] SV = model.SV;
        model.SV = new svm_node[model.l][];
        for (i = 0; i < model.l; ++i) {
            for (int j = 0; j < model.nr_class - 1; ++j) {
                model.sv_coef[j][i] = dis.readDouble();
            }
            int s = dis.readInt();
            svm_node[] p = new svm_node[s];
            for (int j = 0; j < p.length; ++j) {
                p[j] = new svm_node();
                p[j].index = dis.readInt();
                p[j].value = dis.readDouble();
            }
            model.SV[i] = p;
        }
        model.probA = new double[m];
        for (i = 0; i < m; ++i) {
            model.probA[i] = dis.readDouble();
        }
        model.probB = new double[m];
        for (i = 0; i < m; ++i) {
            model.probB[i] = dis.readDouble();
        }
        dis.close();
        return model;
    }

    public static void svm_save_model(OutputStream output, svm_model model) throws IOException {
        int i;
        logger.info((Object)"MySVM.svm_save_model");
        DataOutputStream fp = new DataOutputStream(new BufferedOutputStream(output));
        svm_parameter param = model.param;
        fp.writeBytes("svm_type " + svm_type_table[param.svm_type] + "\n");
        fp.writeBytes("kernel_type " + kernel_type_table[param.kernel_type] + "\n");
        if (param.kernel_type == 1) {
            fp.writeBytes("degree " + param.degree + "\n");
        }
        if (param.kernel_type == 1 || param.kernel_type == 2 || param.kernel_type == 3) {
            fp.writeBytes("gamma " + param.gamma + "\n");
        }
        if (param.kernel_type == 1 || param.kernel_type == 3) {
            fp.writeBytes("coef0 " + param.coef0 + "\n");
        }
        int nr_class = model.nr_class;
        int l = model.l;
        fp.writeBytes("nr_class " + nr_class + "\n");
        fp.writeBytes("total_sv " + l + "\n");
        logger.info((Object)("MySVM.svm_save_model.nr_class" + nr_class));
        logger.info((Object)("MySVM.svm_save_model.total_sv" + l));
        fp.writeBytes("rho");
        for (i = 0; i < nr_class * (nr_class - 1) / 2; ++i) {
            fp.writeBytes(" " + model.rho[i]);
        }
        fp.writeBytes("\n");
        if (model.label != null) {
            fp.writeBytes("label");
            for (i = 0; i < nr_class; ++i) {
                fp.writeBytes(" " + model.label[i]);
            }
            fp.writeBytes("\n");
        }
        if (model.probA != null) {
            fp.writeBytes("probA");
            for (i = 0; i < nr_class * (nr_class - 1) / 2; ++i) {
                fp.writeBytes(" " + model.probA[i]);
            }
            fp.writeBytes("\n");
        }
        if (model.probB != null) {
            fp.writeBytes("probB");
            for (i = 0; i < nr_class * (nr_class - 1) / 2; ++i) {
                fp.writeBytes(" " + model.probB[i]);
            }
            fp.writeBytes("\n");
        }
        if (model.nSV != null) {
            fp.writeBytes("nr_sv");
            for (i = 0; i < nr_class; ++i) {
                fp.writeBytes(" " + model.nSV[i]);
            }
            fp.writeBytes("\n");
        }
        fp.writeBytes("SV\n");
        double[][] sv_coef = model.sv_coef;
        svm_node[][] SV = model.SV;
        for (int i2 = 0; i2 < l; ++i2) {
            for (int j = 0; j < nr_class - 1; ++j) {
                fp.writeBytes(sv_coef[j][i2] + " ");
            }
            svm_node[] p = SV[i2];
            if (param.kernel_type == 4) {
                fp.writeBytes("0:" + (int)p[0].value);
            } else {
                for (int j = 0; j < p.length; ++j) {
                    fp.writeBytes(p[j].index + ":" + p[j].value + " ");
                }
            }
            fp.writeBytes("\n");
        }
        fp.close();
    }

    /*
     * Enabled aggressive block sorting
     */
    public static svm_model svm_load_model(InputStream input) throws IOException {
        int i;
        svm_model model;
        BufferedReader fp;
        block25: {
            svm_parameter param;
            logger.info((Object)"MySVM.svm_load_model.their implementation");
            fp = new BufferedReader(new InputStreamReader(input));
            model = new svm_model();
            model.param = param = new svm_parameter();
            model.rho = null;
            model.probA = null;
            model.probB = null;
            model.label = null;
            model.nSV = null;
            block0: while (true) {
                int i2;
                String arg;
                block28: {
                    block27: {
                        String cmd;
                        block26: {
                            cmd = fp.readLine();
                            arg = cmd.substring(cmd.indexOf(32) + 1);
                            if (!cmd.startsWith("svm_type")) break block26;
                            break block27;
                        }
                        if (cmd.startsWith("kernel_type")) {
                            break block28;
                        } else {
                            StringTokenizer st;
                            int n;
                            if (cmd.startsWith("degree")) {
                                param.degree = MySVM.atoi(arg);
                                continue;
                            }
                            if (cmd.startsWith("gamma")) {
                                param.gamma = MySVM.atof(arg);
                                continue;
                            }
                            if (cmd.startsWith("coef0")) {
                                param.coef0 = MySVM.atof(arg);
                                continue;
                            }
                            if (cmd.startsWith("nr_class")) {
                                model.nr_class = MySVM.atoi(arg);
                                continue;
                            }
                            if (cmd.startsWith("total_sv")) {
                                model.l = MySVM.atoi(arg);
                                continue;
                            }
                            if (cmd.startsWith("rho")) {
                                n = model.nr_class * (model.nr_class - 1) / 2;
                                model.rho = new double[n];
                                st = new StringTokenizer(arg);
                                i = 0;
                                while (true) {
                                    if (i >= n) continue block0;
                                    model.rho[i] = MySVM.atof(st.nextToken());
                                    ++i;
                                }
                            }
                            if (cmd.startsWith("label")) {
                                n = model.nr_class;
                                model.label = new int[n];
                                st = new StringTokenizer(arg);
                                i = 0;
                                while (true) {
                                    if (i >= n) continue block0;
                                    model.label[i] = MySVM.atoi(st.nextToken());
                                    ++i;
                                }
                            }
                            if (cmd.startsWith("probA")) {
                                n = model.nr_class * (model.nr_class - 1) / 2;
                                model.probA = new double[n];
                                st = new StringTokenizer(arg);
                                i = 0;
                                while (true) {
                                    if (i >= n) continue block0;
                                    model.probA[i] = MySVM.atof(st.nextToken());
                                    ++i;
                                }
                            }
                            if (cmd.startsWith("probB")) {
                                n = model.nr_class * (model.nr_class - 1) / 2;
                                model.probB = new double[n];
                                st = new StringTokenizer(arg);
                                i = 0;
                                while (true) {
                                    if (i >= n) continue block0;
                                    model.probB[i] = MySVM.atof(st.nextToken());
                                    ++i;
                                }
                            }
                            if (cmd.startsWith("nr_sv")) {
                                n = model.nr_class;
                                model.nSV = new int[n];
                                st = new StringTokenizer(arg);
                                i = 0;
                                while (true) {
                                    if (i >= n) continue block0;
                                    model.nSV[i] = MySVM.atoi(st.nextToken());
                                    ++i;
                                }
                            }
                            if (!cmd.startsWith("SV")) {
                                logger.error((Object)("unknown text in model file: [" + cmd + "]\n"));
                                return null;
                            }
                            break block25;
                        }
                    }
                    for (i2 = 0; i2 < svm_type_table.length; ++i2) {
                        if (arg.indexOf(svm_type_table[i2]) == -1) continue;
                        param.svm_type = i2;
                        break;
                    }
                    if (i2 != svm_type_table.length) continue;
                    logger.error((Object)"unknown svm type.\n");
                    return null;
                }
                for (i2 = 0; i2 < kernel_type_table.length; ++i2) {
                    if (arg.indexOf(kernel_type_table[i2]) == -1) continue;
                    param.kernel_type = i2;
                    break;
                }
                if (i2 == kernel_type_table.length) break;
            }
            logger.error((Object)"unknown kernel function.\n");
            return null;
        }
        long begin = System.currentTimeMillis();
        int m = model.nr_class - 1;
        int l = model.l;
        model.sv_coef = new double[m][l];
        model.SV = new svm_node[l][];
        i = 0;
        while (true) {
            if (i >= l) {
                long end = System.currentTimeMillis();
                System.out.println("support vector parsed in " + (end - begin) + " ms");
                fp.close();
                return model;
            }
            String line = fp.readLine();
            StringTokenizer st = new StringTokenizer(line, " \t\n\r\f:");
            for (int k = 0; k < m; ++k) {
                model.sv_coef[k][i] = MySVM.atof(st.nextToken());
            }
            int n = st.countTokens() / 2;
            model.SV[i] = new svm_node[n];
            for (int j = 0; j < n; ++j) {
                model.SV[i][j] = new svm_node();
                model.SV[i][j].index = MySVM.atoi(st.nextToken());
                model.SV[i][j].value = MySVM.atof(st.nextToken());
            }
            ++i;
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    public static svm_model svm_load_model(BufferedReader fp) throws IOException {
        svm_model model;
        long begin;
        block25: {
            svm_parameter param;
            logger.info((Object)"MySVM.svm_load_model.my implementation");
            begin = System.currentTimeMillis();
            model = new svm_model();
            model.param = param = new svm_parameter();
            model.rho = null;
            model.probA = null;
            model.probB = null;
            model.label = null;
            model.nSV = null;
            block0: while (true) {
                int i;
                String arg;
                block28: {
                    block27: {
                        String cmd;
                        block26: {
                            cmd = fp.readLine();
                            arg = cmd.substring(cmd.indexOf(32) + 1);
                            if (!cmd.startsWith("svm_type")) break block26;
                            break block27;
                        }
                        if (cmd.startsWith("kernel_type")) {
                            break block28;
                        } else {
                            int i2;
                            StringTokenizer st;
                            int n;
                            if (cmd.startsWith("degree")) {
                                param.degree = MySVM.atoi(arg);
                                continue;
                            }
                            if (cmd.startsWith("gamma")) {
                                param.gamma = MySVM.atof(arg);
                                continue;
                            }
                            if (cmd.startsWith("coef0")) {
                                param.coef0 = MySVM.atof(arg);
                                continue;
                            }
                            if (cmd.startsWith("nr_class")) {
                                model.nr_class = MySVM.atoi(arg);
                                continue;
                            }
                            if (cmd.startsWith("total_sv")) {
                                model.l = MySVM.atoi(arg);
                                continue;
                            }
                            if (cmd.startsWith("rho")) {
                                n = model.nr_class * (model.nr_class - 1) / 2;
                                model.rho = new double[n];
                                st = new StringTokenizer(arg);
                                i2 = 0;
                                while (true) {
                                    if (i2 >= n) continue block0;
                                    model.rho[i2] = MySVM.atof(st.nextToken());
                                    ++i2;
                                }
                            }
                            if (cmd.startsWith("label")) {
                                n = model.nr_class;
                                model.label = new int[n];
                                st = new StringTokenizer(arg);
                                i2 = 0;
                                while (true) {
                                    if (i2 >= n) continue block0;
                                    model.label[i2] = MySVM.atoi(st.nextToken());
                                    ++i2;
                                }
                            }
                            if (cmd.startsWith("probA")) {
                                n = model.nr_class * (model.nr_class - 1) / 2;
                                model.probA = new double[n];
                                st = new StringTokenizer(arg);
                                i2 = 0;
                                while (true) {
                                    if (i2 >= n) continue block0;
                                    model.probA[i2] = MySVM.atof(st.nextToken());
                                    ++i2;
                                }
                            }
                            if (cmd.startsWith("probB")) {
                                n = model.nr_class * (model.nr_class - 1) / 2;
                                model.probB = new double[n];
                                st = new StringTokenizer(arg);
                                i2 = 0;
                                while (true) {
                                    if (i2 >= n) continue block0;
                                    model.probB[i2] = MySVM.atof(st.nextToken());
                                    ++i2;
                                }
                            }
                            if (cmd.startsWith("nr_sv")) {
                                n = model.nr_class;
                                model.nSV = new int[n];
                                st = new StringTokenizer(arg);
                                i2 = 0;
                                while (true) {
                                    if (i2 >= n) continue block0;
                                    model.nSV[i2] = MySVM.atoi(st.nextToken());
                                    ++i2;
                                }
                            }
                            if (!cmd.startsWith("SV")) {
                                logger.error((Object)("unknown text in model file: [" + cmd + "]\n"));
                                return null;
                            }
                            break block25;
                        }
                    }
                    for (i = 0; i < svm_type_table.length; ++i) {
                        if (arg.indexOf(svm_type_table[i]) == -1) continue;
                        param.svm_type = i;
                        break;
                    }
                    if (i != svm_type_table.length) continue;
                    logger.error((Object)"unknown svm type.\n");
                    return null;
                }
                for (i = 0; i < kernel_type_table.length; ++i) {
                    if (arg.indexOf(kernel_type_table[i]) == -1) continue;
                    param.kernel_type = i;
                    break;
                }
                if (i == kernel_type_table.length) break;
            }
            logger.error((Object)"unknown kernel function.\n");
            return null;
        }
        long end = System.currentTimeMillis();
        logger.info((Object)("param parsed in " + (end - begin) + " ms"));
        begin = System.currentTimeMillis();
        int m = model.nr_class - 1;
        int l = model.l;
        model.sv_coef = new double[m][l];
        model.SV = new svm_node[l][];
        String[] s1 = null;
        Object s2 = null;
        int n = 0;
        int z = 0;
        int i = 0;
        while (true) {
            if (i >= l) {
                end = System.currentTimeMillis();
                logger.info((Object)(model.l + " support vectors parsed in " + (end - begin) + " ms"));
                fp.close();
                return model;
            }
            String line = fp.readLine();
            s1 = spacePattern.split(line);
            for (int k = 0; k < m; ++k) {
                model.sv_coef[k][i] = Double.parseDouble(s1[k]);
            }
            n = s1.length - m;
            model.SV[i] = new svm_node[n];
            for (int j = 0; j < n; ++j) {
                model.SV[i][j] = new svm_node();
                z = s1[j + m].indexOf(58);
                model.SV[i][j].index = Integer.parseInt(s1[j + m].substring(0, z));
                model.SV[i][j].value = Double.parseDouble(s1[j + m].substring(z + 1, s1[j + m].length()));
            }
            ++i;
        }
    }

    public static void main(String[] args) throws Exception {
        String logConfig = System.getProperty("log-config");
        if (logConfig == null) {
            logConfig = "log-config.txt";
        }
        PropertyConfigurator.configure((String)logConfig);
        if (args.length != 2) {
            logger.info((Object)"java mylibsvm.MySVM in out");
            System.exit(1);
        }
        svm_model model = MySVM.svm_load_model(new FileInputStream(args[0]));
        MySVM.my_svm_save_model(new FileOutputStream(args[0] + ".mine"), model);
        svm_model model1 = MySVM.my_svm_load_model(new FileInputStream(args[0] + ".mine"));
        MySVM.svm_save_model(new FileOutputStream(args[1]), model1);
    }
}

