/*
 * Decompiled with CFR 0.152.
 */
package eu.fbk.utils.mylibsvm;

import eu.fbk.utils.mylibsvm.svm;
import eu.fbk.utils.mylibsvm.svm_model;
import eu.fbk.utils.mylibsvm.svm_node;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.DataOutputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.text.DecimalFormat;
import java.util.StringTokenizer;
import org.apache.log4j.Logger;
import org.apache.log4j.PropertyConfigurator;

public class svm_multiclass_predict {
    static Logger logger = Logger.getLogger((String)svm_multiclass_predict.class.getName());

    private static double atof(String s) {
        return Double.valueOf(s);
    }

    private static int atoi(String s) {
        return Integer.parseInt(s);
    }

    public static void predict(BufferedReader input, DataOutputStream output, svm_model model, int predict_probability) throws IOException {
        String line;
        DecimalFormat decFormatter = new DecimalFormat("0.00");
        double tp = 0.0;
        double fp = 0.0;
        double fn = 0.0;
        double tn = 0.0;
        int correct = 0;
        int total = 0;
        double error = 0.0;
        double sumv = 0.0;
        double sumy = 0.0;
        double sumvv = 0.0;
        double sumyy = 0.0;
        double sumvy = 0.0;
        int svm_type = svm.svm_get_svm_type(model);
        int nr_class = svm.svm_get_nr_class(model);
        double[] prob_estimates = null;
        if (predict_probability == 1) {
            if (svm_type == 3 || svm_type == 4) {
                logger.info((Object)("Prob. model for test data: target value = predicted value + z,\nz: Laplace distribution e^(-|z|/sigma)/(2sigma),sigma=" + svm.svm_get_svr_probability(model) + "\n"));
            } else {
                int[] labels = new int[nr_class];
                svm.svm_get_labels(model, labels);
                prob_estimates = new double[nr_class];
                output.writeBytes("labels");
                for (int j = 0; j < nr_class; ++j) {
                    output.writeBytes(" " + labels[j]);
                }
                output.writeBytes("\n");
            }
        }
        while ((line = input.readLine()) != null) {
            double v;
            StringTokenizer st = new StringTokenizer(line, " \t\n\r\f:");
            double target = svm_multiclass_predict.atof(st.nextToken());
            int m = st.countTokens() / 2;
            svm_node[] x = new svm_node[m];
            for (int j = 0; j < m; ++j) {
                x[j] = new svm_node();
                x[j].index = svm_multiclass_predict.atoi(st.nextToken());
                x[j].value = svm_multiclass_predict.atof(st.nextToken());
            }
            if (predict_probability == 1 && (svm_type == 0 || svm_type == 1)) {
                v = svm.svm_predict_probability(model, x, prob_estimates);
                output.writeBytes(v + " ");
                for (int j = 0; j < nr_class; ++j) {
                    output.writeBytes(prob_estimates[j] + " ");
                }
                output.writeBytes("\n");
            } else {
                double[] res = svm.svm_predict_score(model, x);
                v = res[1];
                output.writeBytes(v + "\t" + res[0] + "\n");
            }
            if (v == target) {
                ++correct;
            }
            if (v == 0.0) {
                if (target == v) {
                    tn += 1.0;
                } else {
                    fn += 1.0;
                }
            } else if (target == 0.0) {
                fp += 1.0;
            } else if (target == v) {
                tp += 1.0;
            } else {
                fp += 1.0;
                fn += 1.0;
            }
            error += (v - target) * (v - target);
            sumv += v;
            sumy += target;
            sumvv += v * v;
            sumyy += target * target;
            sumvy += v * target;
            ++total;
        }
        if (svm_type == 3 || svm_type == 4) {
            logger.info((Object)("Mean squared error = " + error / (double)total + " (regression)\n"));
            logger.info((Object)("Squared correlation coefficient = " + ((double)total * sumvy - sumv * sumy) * ((double)total * sumvy - sumv * sumy) / (((double)total * sumvv - sumv * sumv) * ((double)total * sumyy - sumy * sumy)) + " (regression)\n"));
        } else {
            double p = tp / (tp + fp);
            double r = tp / (tp + fn);
            double f1 = 2.0 * p * r / (p + r);
            logger.info((Object)("Accuracy = " + (double)correct / (double)total * 100.0 + "% (" + correct + "/" + total + ") (classification)\n"));
            logger.info((Object)"tp\tfp\tfn\tsize\tp\tr\tf1");
            logger.info((Object)((int)tp + "\t" + (int)fp + "\t" + (int)fn + "\t" + total + "\t" + decFormatter.format(p) + "\t" + decFormatter.format(r) + "\t" + decFormatter.format(f1)));
        }
    }

    private static void exit_with_help() {
        logger.error((Object)"usage: svm_multiclass_predict [options] test_file model_file output_file\noptions:\n-b probability_estimates: whether to predict probability estimates, 0 or 1 (default 0); one-class SVM not supported yet\n");
        System.exit(1);
    }

    public static void main(String[] argv) throws IOException {
        int i;
        String logConfig = System.getProperty("log-config");
        if (logConfig == null) {
            logConfig = "log-config.txt";
        }
        PropertyConfigurator.configure((String)logConfig);
        int predict_probability = 0;
        block6: for (i = 0; i < argv.length && argv[i].charAt(0) == '-'; ++i) {
            switch (argv[++i - 1].charAt(1)) {
                case 'b': {
                    predict_probability = svm_multiclass_predict.atoi(argv[i]);
                    continue block6;
                }
                default: {
                    logger.error((Object)("Unknown option: " + argv[i - 1] + "\n"));
                    svm_multiclass_predict.exit_with_help();
                }
            }
        }
        if (i >= argv.length - 2) {
            svm_multiclass_predict.exit_with_help();
        }
        try {
            BufferedReader input = new BufferedReader(new FileReader(argv[i]));
            DataOutputStream output = new DataOutputStream(new BufferedOutputStream(new FileOutputStream(argv[i + 2])));
            svm_model model = svm.svm_load_model(argv[i + 1]);
            if (predict_probability == 1) {
                if (svm.svm_check_probability_model(model) == 0) {
                    logger.error((Object)"Model does not support probabiliy estimates\n");
                    System.exit(1);
                }
            } else if (svm.svm_check_probability_model(model) != 0) {
                logger.info((Object)"Model supports probability estimates, but disabled in prediction.\n");
            }
            svm_multiclass_predict.predict(input, output, model, predict_probability);
            input.close();
            output.close();
        }
        catch (FileNotFoundException e) {
            svm_multiclass_predict.exit_with_help();
        }
        catch (ArrayIndexOutOfBoundsException e) {
            svm_multiclass_predict.exit_with_help();
        }
    }
}

