/*
 * Decompiled with CFR 0.152.
 */
package eu.fbk.utils.mylibsvm;

import eu.fbk.utils.mylibsvm.svm_multiclass_predict;
import eu.fbk.utils.mylibsvm.svm_train;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.LineNumberReader;
import java.io.PrintWriter;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.apache.log4j.Logger;
import org.apache.log4j.PropertyConfigurator;

public class OVA {
    static Logger logger = Logger.getLogger((String)OVA.class.getName());

    public OVA(File train, File test, String root, double w) throws IOException {
        double[] part = this.run(train, test, root, w);
    }

    public OVA(File dataset, int n, String root, double w) throws IOException {
        DecimalFormat decFormatter = new DecimalFormat("0.00");
        double[] res = new double[4];
        List<Pair> dataList = this.readDataset(dataset);
        for (int i = 0; i < n; ++i) {
            logger.info((Object)("CROSS VALIDATION START " + i + "/" + n));
            File train = new File(dataset.getAbsolutePath() + "_train_" + n);
            File test = new File(dataset.getAbsolutePath() + "_test_" + n);
            this.split(dataList, train, test, i, n);
            double[] part = this.run(train, test, root, w);
            for (int k = 0; k < part.length; ++k) {
                int n2 = k;
                res[n2] = res[n2] + part[k];
            }
            logger.info((Object)("CROSS VALIDATION END " + i + "/" + n));
        }
        double p = res[0] / (res[0] + res[1]);
        double r = res[0] / (res[0] + res[2]);
        double f1 = 2.0 * p * r / (p + r);
        logger.info((Object)"tp\tfp\tfn\tsize\tp\tr\tf1");
        logger.info((Object)((int)res[0] + "\t" + (int)res[1] + "\t" + (int)res[2] + "\t" + (int)res[3] + "\t" + decFormatter.format(p) + "\t" + decFormatter.format(r) + "\t" + decFormatter.format(f1)));
    }

    private void split(List<Pair> dataList, File train, File test, int j, int n) throws IOException {
        PrintWriter testWriter = new PrintWriter(new FileWriter(test));
        PrintWriter trainWriter = new PrintWriter(new FileWriter(train));
        for (int i = 0; i < dataList.size(); ++i) {
            int k = i + j;
            if (k % n == 0) {
                testWriter.println(dataList.get((int)i).c + " " + dataList.get((int)i).e);
                continue;
            }
            trainWriter.println(dataList.get((int)i).c + " " + dataList.get((int)i).e);
        }
        testWriter.close();
        trainWriter.close();
    }

    public double[] run(File train, File test, String root, double w) throws IOException {
        List<Pair> trainList = this.readDataset(train);
        List<Pair> testList = this.readDataset(test);
        Set<String> set = this.classes(trainList);
        String[] y = new String[set.size()];
        ArrayList<List<Double[]>> d = new ArrayList<List<Double[]>>();
        Iterator<String> it = set.iterator();
        int i = 0;
        while (it.hasNext()) {
            String c;
            y[i] = c = it.next();
            logger.info((Object)c);
            String trainFile = root + "_train_" + c;
            String testFile = root + "_test_" + c;
            String modelFile = root + "_mdl_" + c;
            String outFile = root + "_out_" + c;
            this.writeProblem(trainList, c, trainFile);
            this.writeProblem(testList, c, testFile);
            svm_train t = new svm_train();
            String[] argv = new String[8];
            argv[0] = "-t";
            argv[1] = "0";
            argv[2] = "-m";
            argv[3] = "2000";
            argv[4] = "-w1";
            argv[5] = new Double(w).toString();
            logger.info((Object)("class " + c + " => " + argv[5]));
            argv[6] = trainFile;
            argv[7] = modelFile;
            svm_train.main(argv);
            svm_multiclass_predict p = new svm_multiclass_predict();
            String[] argc = new String[]{testFile, modelFile, outFile};
            svm_multiclass_predict.main(argc);
            d.add(this.readOutput(new File(outFile)));
            ++i;
        }
        PrintWriter pw = new PrintWriter(new FileWriter(root + "_result"));
        ArrayList<Double> resList = new ArrayList<Double>();
        for (int j = 0; j < ((List)d.get(0)).size(); ++j) {
            int maxi = -1;
            double maxv = 0.0;
            for (int k = 0; k < y.length; ++k) {
                if (!(((Double[])((List)d.get(k)).get(j))[0] > 0.0) || !(Math.abs(((Double[])((List)d.get(k)).get(j))[1]) > maxv)) continue;
                maxi = k;
                maxv = ((Double[])((List)d.get(k)).get(j))[1];
            }
            if (maxi > -1) {
                pw.println(y[maxi] + "\t" + maxv);
                resList.add(new Double(y[maxi]));
                continue;
            }
            pw.println("0\t0");
            resList.add(0.0);
        }
        pw.close();
        return this.eval(resList, testList);
    }

    private double[] eval(List<Double> resList, List<Pair> testList) {
        DecimalFormat decFormatter = new DecimalFormat("0.00");
        int correct = 0;
        int total = 0;
        double tp = 0.0;
        double fp = 0.0;
        double fn = 0.0;
        double error = 0.0;
        double sumv = 0.0;
        double sumy = 0.0;
        double sumvv = 0.0;
        double sumyy = 0.0;
        double sumvy = 0.0;
        logger.info((Object)("eval " + resList.size() + ", " + testList.size()));
        for (int i = 0; i < resList.size(); ++i) {
            double target = Double.parseDouble(testList.get((int)i).c);
            double v = resList.get(i);
            if (v == target) {
                ++correct;
            }
            if (v == 0.0) {
                fn += 1.0;
            } else if (v == target) {
                tp += 1.0;
            } else {
                fp += 1.0;
                fn += 1.0;
            }
            error += (v - target) * (v - target);
            sumv += v;
            sumy += target;
            sumvv += v * v;
            sumyy += target * target;
            sumvy += v * target;
            ++total;
        }
        logger.info((Object)("Accuracy = " + (double)correct / (double)total * 100.0 + "% (" + correct + "/" + total + ") (classification)\n"));
        double p = tp / (tp + fp);
        double r = tp / (tp + fn);
        double f1 = 2.0 * p * r / (p + r);
        logger.info((Object)"===\ntp\tfp\tfn\tsize\tp\tr\tf1");
        logger.info((Object)((int)tp + "\t" + (int)fp + "\t" + (int)fn + "\t" + resList.size() + "\t" + decFormatter.format(p) + "\t" + decFormatter.format(r) + "\t" + decFormatter.format(f1) + "\n==="));
        double[] res = new double[]{tp, fp, fn, total};
        return res;
    }

    private List<Double[]> readOutput(File f) throws IOException {
        ArrayList<Double[]> list = new ArrayList<Double[]>();
        LineNumberReader lr = new LineNumberReader(new FileReader(f));
        String line = null;
        while ((line = lr.readLine()) != null) {
            String[] s = line.split("\t");
            Double[] d = new Double[]{Double.parseDouble(s[0]), Double.parseDouble(s[1])};
            list.add(d);
        }
        return list;
    }

    private void writeProblem(List<Pair> list, String c, String name) throws IOException {
        PrintWriter pw = new PrintWriter(new FileWriter(name));
        for (int i = 0; i < list.size(); ++i) {
            if (c.equals(list.get((int)i).c)) {
                pw.print("1");
            } else {
                pw.print("0");
            }
            pw.println(" " + list.get((int)i).e);
        }
        pw.close();
    }

    private Set<String> classes(List<Pair> list) {
        HashSet<String> set = new HashSet<String>();
        for (int i = 0; i < list.size(); ++i) {
            set.add(list.get((int)i).c);
        }
        return set;
    }

    private List<Pair> readDataset(File f) throws IOException {
        ArrayList<Pair> list = new ArrayList<Pair>();
        LineNumberReader lr = new LineNumberReader(new FileReader(f));
        String line = null;
        while ((line = lr.readLine()) != null) {
            int i = line.indexOf(" ");
            String c = line.substring(0, i);
            String e = line.substring(i + 1, line.length());
            list.add(new Pair(c, e));
        }
        return list;
    }

    public static void main(String[] args) throws Exception {
        String logConfig = System.getProperty("log-config");
        if (logConfig == null) {
            logConfig = "log-config.txt";
        }
        PropertyConfigurator.configure((String)logConfig);
        new OVA(new File(args[0]), new File(args[1]), args[2], Double.parseDouble(args[3]));
    }

    class Pair {
        String c;
        String e;

        public Pair(String c, String e) {
            this.c = c;
            this.e = e;
        }
    }
}

