/*
 * Decompiled with CFR 0.152.
 */
package eu.fbk.utils.corenlp;

import edu.stanford.nlp.ling.CoreAnnotations;
import edu.stanford.nlp.ling.CoreLabel;
import edu.stanford.nlp.pipeline.Annotation;
import edu.stanford.nlp.util.ArrayCoreMap;
import java.util.ArrayList;
import java.util.List;

public class Utils {
    public static void addBasicAnnotations(Annotation annotation, List<List<CoreLabel>> sTokens) {
        String text = (String)annotation.get(CoreAnnotations.TextAnnotation.class);
        Utils.addBasicAnnotations(annotation, sTokens, text);
    }

    public static void addBasicAnnotations(Annotation annotation, List<List<CoreLabel>> sTokens, String text) {
        ArrayList<ArrayCoreMap> sentences = new ArrayList<ArrayCoreMap>();
        ArrayList<CoreLabel> tokens = new ArrayList<CoreLabel>();
        int sIndex = 0;
        int tokenIndex = 0;
        for (List<CoreLabel> sentence : sTokens) {
            if (sentence.size() == 0) continue;
            ArrayCoreMap sent = new ArrayCoreMap(1);
            for (CoreLabel coreLabel : sentence) {
                coreLabel.setSentIndex(sIndex);
            }
            int begin = sentence.get(0).beginPosition();
            int end = sentence.get(sentence.size() - 1).endPosition();
            sent.set(CoreAnnotations.TokensAnnotation.class, sentence);
            sent.set(CoreAnnotations.SentenceIndexAnnotation.class, (Object)sIndex++);
            sent.set(CoreAnnotations.CharacterOffsetBeginAnnotation.class, (Object)begin);
            sent.set(CoreAnnotations.CharacterOffsetEndAnnotation.class, (Object)end);
            sent.set(CoreAnnotations.TokenBeginAnnotation.class, (Object)tokenIndex);
            sent.set(CoreAnnotations.TokenEndAnnotation.class, (Object)(tokenIndex += sentence.size()));
            sent.set(CoreAnnotations.TextAnnotation.class, (Object)text.substring(begin, end));
            sentences.add(sent);
            tokens.addAll(sentence);
        }
        annotation.set(CoreAnnotations.TokensAnnotation.class, tokens);
        annotation.set(CoreAnnotations.SentencesAnnotation.class, sentences);
    }
}

