/*
 * Decompiled with CFR 0.152.
 */
package eu.fbk.utils.corenlp.outputters;

import edu.stanford.nlp.io.IOUtils;
import edu.stanford.nlp.ling.CoreAnnotations;
import edu.stanford.nlp.ling.CoreLabel;
import edu.stanford.nlp.ling.IndexedWord;
import edu.stanford.nlp.pipeline.Annotation;
import edu.stanford.nlp.pipeline.AnnotationOutputter;
import edu.stanford.nlp.pipeline.StanfordCoreNLP;
import edu.stanford.nlp.semgraph.SemanticGraph;
import edu.stanford.nlp.semgraph.SemanticGraphCoreAnnotations;
import edu.stanford.nlp.semgraph.SemanticGraphEdge;
import edu.stanford.nlp.trees.GrammaticalRelation;
import edu.stanford.nlp.util.CoreMap;
import edu.stanford.nlp.util.StringUtils;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

public class TextProOutputter
extends AnnotationOutputter {
    private static final String NULL_PLACEHOLDER = "_";
    private static final String ENTITY_NULL_PLACEHOLDER = "O";

    private static String orNull(String in) {
        return TextProOutputter.orNull(in, NULL_PLACEHOLDER);
    }

    private static String orNull(String in, String ph) {
        if (in == null) {
            return ph;
        }
        return in;
    }

    private static String line(int index, CoreLabel token, int head, String deprel) {
        return TextProOutputter.line(index, token, head, deprel, 0);
    }

    private static String line(int index, CoreLabel token, int head, String deprel, int lastIndex) {
        ArrayList<String> fields = new ArrayList<String>(16);
        fields.add(Integer.toString(index));
        fields.add(Integer.toString(index - lastIndex));
        fields.add(TextProOutputter.orNull(token.word()));
        fields.add(TextProOutputter.orNull(token.lemma()));
        fields.add(TextProOutputter.orNull(token.tag()));
        fields.add(TextProOutputter.orNull(token.ner()));
        if (head >= 0) {
            fields.add(Integer.toString(Math.max(0, head - lastIndex)));
            fields.add(deprel);
        } else {
            fields.add(NULL_PLACEHOLDER);
            fields.add(NULL_PLACEHOLDER);
        }
        return StringUtils.join(fields, (String)"\t");
    }

    public void print(Annotation doc, OutputStream target, AnnotationOutputter.Options options) throws IOException {
        PrintWriter writer = new PrintWriter(IOUtils.encodedOutputStreamWriter((OutputStream)target, (String)options.encoding));
        ArrayList<String> fields = new ArrayList<String>();
        fields.add("tokenid");
        fields.add("parserid");
        fields.add("token");
        fields.add("lemma");
        fields.add("pos");
        fields.add("entity");
        fields.add("head");
        fields.add("deprel");
        writer.println("# FIELDS: " + StringUtils.join(fields, (String)"\t"));
        int lastIndex = 0;
        if (doc.get(CoreAnnotations.SentencesAnnotation.class) != null) {
            for (CoreMap sentence : (List)doc.get(CoreAnnotations.SentencesAnnotation.class)) {
                if (sentence.get(CoreAnnotations.TokensAnnotation.class) == null) continue;
                SemanticGraph depTree = (SemanticGraph)sentence.get(SemanticGraphCoreAnnotations.BasicDependenciesAnnotation.class);
                Integer index = 0;
                List tokens = (List)sentence.get(CoreAnnotations.TokensAnnotation.class);
                if (depTree != null) {
                    tokens = depTree.vertexListSorted();
                }
                int govIdx = -1;
                String relnName = null;
                for (int i = 0; i < tokens.size(); ++i) {
                    CoreLabel coreLabel;
                    Object token = tokens.get(i);
                    if (token instanceof IndexedWord) {
                        IndexedWord thisToken = (IndexedWord)token;
                        govIdx = -1;
                        GrammaticalRelation reln = null;
                        HashMap<Integer, String> additionalDeps = new HashMap<Integer, String>();
                        for (IndexedWord parent : depTree.getParents(thisToken)) {
                            SemanticGraphEdge edge = depTree.getEdge(parent, thisToken);
                            if (govIdx == -1 && !edge.isExtra()) {
                                govIdx = parent.index();
                                reln = edge.getRelation();
                                continue;
                            }
                            additionalDeps.put(parent.index(), edge.getRelation().toString());
                        }
                        if (govIdx == -1) {
                            govIdx = 0;
                            reln = GrammaticalRelation.ROOT;
                        }
                        relnName = reln == null ? NULL_PLACEHOLDER : reln.toString();
                        coreLabel = thisToken.backingLabel();
                    } else {
                        coreLabel = (CoreLabel)token;
                    }
                    index = (Integer)coreLabel.get(CoreAnnotations.IndexAnnotation.class);
                    writer.print(TextProOutputter.line(index, coreLabel, govIdx, relnName, lastIndex));
                    writer.println();
                }
                lastIndex = index;
                writer.println();
            }
        }
        writer.flush();
    }

    public static void tpPrint(Annotation annotation, OutputStream os) throws IOException {
        new TextProOutputter().print(annotation, os);
    }

    public static void tpPrint(Annotation annotation, OutputStream os, StanfordCoreNLP pipeline) throws IOException {
        new TextProOutputter().print(annotation, os, pipeline);
    }

    public static void tpPrint(Annotation annotation, OutputStream os, AnnotationOutputter.Options options) throws IOException {
        new TextProOutputter().print(annotation, os, options);
    }
}

