/*
 * Decompiled with CFR 0.152.
 */
package eu.fbk.fcw.mst.api;

import edu.stanford.nlp.ling.CoreAnnotation;
import edu.stanford.nlp.ling.CoreAnnotations;
import edu.stanford.nlp.ling.CoreLabel;
import edu.stanford.nlp.pipeline.Annotation;
import edu.stanford.nlp.pipeline.Annotator;
import edu.stanford.nlp.util.ArraySet;
import edu.stanford.nlp.util.CoreMap;
import eu.fbk.dkm.pikes.depparseannotation.DepParseInfo;
import eu.fbk.dkm.pikes.depparseannotation.DepparseAnnotations;
import eu.fbk.fcw.mst.api.MstServerParser;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Properties;
import java.util.Set;

public class MstServerParserAnnotator
implements Annotator {
    MstServerParser parser;
    int maxLen = -1;

    public MstServerParserAnnotator(String annotatorName, Properties props) {
        String server = props.getProperty(annotatorName + ".server");
        Integer port = Integer.parseInt(props.getProperty(annotatorName + ".port"));
        if (props.containsKey(annotatorName + ".maxlen")) {
            this.maxLen = Integer.parseInt(props.getProperty(annotatorName + ".maxlen"));
        }
        this.parser = new MstServerParser(server, port);
    }

    public void annotate(Annotation annotation) {
        if (annotation.containsKey(CoreAnnotations.SentencesAnnotation.class)) {
            for (CoreMap sentence : (List)annotation.get(CoreAnnotations.SentencesAnnotation.class)) {
                List tokens = (List)sentence.get(CoreAnnotations.TokensAnnotation.class);
                if (this.maxLen > 0 && tokens.size() > this.maxLen) continue;
                ArrayList<String> forms = new ArrayList<String>();
                ArrayList<String> poss = new ArrayList<String>();
                for (CoreLabel stanfordToken : tokens) {
                    String form = (String)stanfordToken.get(CoreAnnotations.TextAnnotation.class);
                    String pos = (String)stanfordToken.get(CoreAnnotations.PartOfSpeechAnnotation.class);
                    forms.add(form);
                    poss.add(pos);
                }
                try {
                    DepParseInfo depParseInfo = this.parser.tag(forms, poss);
                    sentence.set(DepparseAnnotations.MstParserAnnotation.class, (Object)depParseInfo);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        } else {
            throw new RuntimeException("unable to find words/tokens in: " + annotation);
        }
    }

    public Set<Class<? extends CoreAnnotation>> requirementsSatisfied() {
        return Collections.singleton(DepparseAnnotations.MstParserAnnotation.class);
    }

    public Set<Class<? extends CoreAnnotation>> requires() {
        return Collections.unmodifiableSet(new ArraySet(Arrays.asList(CoreAnnotations.TokensAnnotation.class, CoreAnnotations.SentencesAnnotation.class, CoreAnnotations.PartOfSpeechAnnotation.class)));
    }
}

