/*
 * Decompiled with CFR 0.152.
 */
package eu.fbk.fcw.herodotos;

import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import edu.stanford.nlp.ling.CoreAnnotation;
import edu.stanford.nlp.ling.CoreAnnotations;
import edu.stanford.nlp.ling.CoreLabel;
import edu.stanford.nlp.pipeline.Annotation;
import edu.stanford.nlp.pipeline.Annotator;
import edu.stanford.nlp.util.ArraySet;
import edu.stanford.nlp.util.CoreMap;
import eu.fbk.utils.core.PropertiesUtils;
import eu.fbk.utils.gson.Network;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Properties;
import java.util.Set;

public class HerodotosAnnotator
implements Annotator {
    private static String HERODOTOS_SERVER = "localhost";
    private static Integer HERODOTOS_PORT = 9006;
    private String server;
    private Integer port;

    public HerodotosAnnotator(String annotatorName, Properties props) throws Exception {
        Properties newProps = PropertiesUtils.dotConvertedProperties((Properties)props, (String)annotatorName);
        this.server = newProps.getProperty("server", HERODOTOS_SERVER);
        this.port = PropertiesUtils.getInteger((String)newProps.getProperty("port"), (int)HERODOTOS_PORT);
    }

    public void annotate(Annotation annotation) {
        JsonParser parser = new JsonParser();
        StringBuilder builder = new StringBuilder();
        for (CoreMap sentence : (List)annotation.get(CoreAnnotations.SentencesAnnotation.class)) {
            for (CoreLabel token : (List)sentence.get(CoreAnnotations.TokensAnnotation.class)) {
                builder.append(token.originalText()).append("\n");
            }
            builder.append("\n");
        }
        builder.append("\n");
        HashMap<String, String> pars = new HashMap<String, String>();
        pars.put("text", builder.toString());
        pars.put("outputFormat", "crf");
        ArrayList ners = new ArrayList();
        try {
            String[] sentences;
            String output = Network.postRequest((String)this.server, (int)this.port, pars);
            JsonObject object = parser.parse(output).getAsJsonObject();
            String string = object.get("output").getAsString();
            for (String sentence : sentences = string.split("\n{2,}")) {
                if (sentence.trim().length() == 0) continue;
                String[] words = sentence.split("\n");
                ArrayList<String> sentenceNers = new ArrayList<String>();
                for (String word : words) {
                    if (word.trim().length() == 0) continue;
                    String[] parts = word.split("\\s+");
                    sentenceNers.add(parts[0]);
                }
                ners.add(sentenceNers);
            }
            int sentenceID = 0;
            for (CoreMap sentence : (List)annotation.get(CoreAnnotations.SentencesAnnotation.class)) {
                int tokenID = 0;
                for (CoreLabel token : (List)sentence.get(CoreAnnotations.TokensAnnotation.class)) {
                    String ner = (String)((List)ners.get(sentenceID)).get(tokenID);
                    if (ner.equals("0")) {
                        ner = "O";
                    }
                    token.set(CoreAnnotations.NamedEntityTagAnnotation.class, (Object)ner);
                    ++tokenID;
                }
                ++sentenceID;
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public Set<Class<? extends CoreAnnotation>> requirementsSatisfied() {
        return Collections.unmodifiableSet(new ArraySet(Arrays.asList(CoreAnnotations.NamedEntityTagAnnotation.class)));
    }

    public Set<Class<? extends CoreAnnotation>> requires() {
        return Collections.unmodifiableSet(new ArraySet(Arrays.asList(CoreAnnotations.TokensAnnotation.class, CoreAnnotations.SentencesAnnotation.class)));
    }
}

