/*
 * Decompiled with CFR 0.152.
 */
package eu.fbk.dh.tint.kd.annotator;

import edu.stanford.nlp.ling.CoreAnnotations;
import edu.stanford.nlp.ling.CoreLabel;
import edu.stanford.nlp.pipeline.Annotation;
import edu.stanford.nlp.pipeline.Annotator;
import edu.stanford.nlp.util.ArraySet;
import edu.stanford.nlp.util.CoreMap;
import eu.fbk.dh.tint.kd.annotator.DigiKdAnnotations;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Properties;
import java.util.Set;

public class DigiKdAnnotator
implements Annotator {
    public DigiKdAnnotator(String annotatorName, Properties prop) {
    }

    public void annotate(Annotation annotation) {
        StringBuffer doc = new StringBuffer();
        if (annotation.has(CoreAnnotations.SentencesAnnotation.class)) {
            for (CoreMap sentence : (List)annotation.get(CoreAnnotations.SentencesAnnotation.class)) {
                List tokens = (List)sentence.get(CoreAnnotations.TokensAnnotation.class);
                for (CoreLabel c : tokens) {
                    doc.append(c.word() + "\t" + (String)c.get(CoreAnnotations.LemmaAnnotation.class) + "\t" + (String)c.get(CoreAnnotations.PartOfSpeechAnnotation.class) + "\n");
                }
                doc.append("\n");
            }
        }
        ArrayList listOfKeys = new ArrayList();
        annotation.set(DigiKdAnnotations.KeyphrasesAnnotation.class, listOfKeys);
    }

    public Set<Annotator.Requirement> requirementsSatisfied() {
        return Collections.singleton(DigiKdAnnotations.DH_KEYPHRASE_REQUIREMENT);
    }

    public Set<Annotator.Requirement> requires() {
        return Collections.unmodifiableSet(new ArraySet((Object[])new Annotator.Requirement[]{TOKENIZE_REQUIREMENT, LEMMA_REQUIREMENT, SSPLIT_REQUIREMENT, POS_REQUIREMENT}));
    }
}

