/*
 * Decompiled with CFR 0.152.
 */
package eu.fbk.dh.tint.geoloc.annotator;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonParser;
import edu.stanford.nlp.ling.CoreAnnotations;
import edu.stanford.nlp.ling.CoreLabel;
import edu.stanford.nlp.pipeline.Annotation;
import edu.stanford.nlp.pipeline.Annotator;
import edu.stanford.nlp.util.ArraySet;
import edu.stanford.nlp.util.CoreMap;
import eu.fbk.dh.tint.geoloc.annotator.GeocodResult;
import eu.fbk.dh.tint.geoloc.annotator.GeolocAnnotations;
import eu.fbk.dh.tint.geoloc.annotator.GeolocConfiguration;
import eu.fbk.dh.tint.geoloc.annotator.GeolocModel;
import eu.fbk.utils.core.PropertiesUtils;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GeolocAnnotator
implements Annotator {
    GeolocConfiguration geoloc_conf;
    private static final Logger LOGGER = LoggerFactory.getLogger(GeolocAnnotator.class);
    private static final String DEFAULT_ENTITY_TYPES = "LOC";
    private static final String DEFAULT_NO_ENTITY = "O";
    private boolean setRaw = false;

    public GeolocAnnotator(String annotatorName, Properties prop) {
        ArrayList<String> allowed_entities = new ArrayList<String>();
        String entityTypes = prop.getProperty(annotatorName + ".allowed_entity_type", DEFAULT_ENTITY_TYPES);
        for (String entity : entityTypes.split(",")) {
            entity = entity.trim();
            allowed_entities.add(entity);
        }
        String geocoder_url = prop.getProperty(annotatorName + ".geocoder_url");
        Boolean use_local_geocoder = PropertiesUtils.getBoolean((String)prop.getProperty(annotatorName + ".use_local_geocoder"), (boolean)false);
        Integer timeout = 1050;
        if (use_local_geocoder.booleanValue()) {
            timeout = PropertiesUtils.getInteger((String)prop.getProperty(annotatorName + ".timeout"), (int)timeout);
        }
        this.geoloc_conf = GeolocModel.getInstance(allowed_entities, geocoder_url, use_local_geocoder, timeout);
        this.setRaw = PropertiesUtils.getBoolean((String)prop.getProperty(annotatorName + ".set_raw"), (boolean)this.setRaw);
    }

    synchronized String request(String word) throws IOException {
        String inputLine;
        String geocoder_url = this.geoloc_conf.getNominatin_url();
        if (this.geoloc_conf.isUse_local_geocoder_instance()) {
            geocoder_url = this.geoloc_conf.getLocal_geocoder_url() + "?format=json&q=";
        }
        URL geocoder_address = new URL(geocoder_url + URLEncoder.encode(word, "UTF-8"));
        LOGGER.debug(geocoder_address.toString());
        URLConnection gconn = geocoder_address.openConnection();
        BufferedReader in = new BufferedReader(new InputStreamReader(gconn.getInputStream(), "UTF-8"));
        StringBuilder a = new StringBuilder();
        while ((inputLine = in.readLine()) != null) {
            a.append(inputLine);
        }
        in.close();
        return a.toString();
    }

    public void annotate(Annotation annotation) {
        ArrayList<GeocodResult> res = new ArrayList<GeocodResult>();
        HashMap<String, GeocodResult> cache = new HashMap<String, GeocodResult>();
        if (annotation.has(CoreAnnotations.SentencesAnnotation.class)) {
            for (CoreMap sentence : (List)annotation.get(CoreAnnotations.SentencesAnnotation.class)) {
                String lastNer = DEFAULT_NO_ENTITY;
                HashMap<Integer, Integer> tokensToEvaluate = new HashMap<Integer, Integer>();
                Integer lastTokenToEvaluate = null;
                List tokens = (List)sentence.get(CoreAnnotations.TokensAnnotation.class);
                HashMap<Integer, CoreLabel> tokensIndex = new HashMap<Integer, CoreLabel>();
                for (CoreLabel c : tokens) {
                    tokensIndex.put(c.index(), c);
                    String ner = c.ner();
                    if (ner == null) {
                        ner = DEFAULT_NO_ENTITY;
                    }
                    if (!this.geoloc_conf.getAllowed_loc_type().contains(ner)) {
                        ner = DEFAULT_NO_ENTITY;
                    }
                    if (ner.equals(DEFAULT_NO_ENTITY)) {
                        lastTokenToEvaluate = null;
                    } else if (lastNer.equals(ner)) {
                        tokensToEvaluate.put(lastTokenToEvaluate, c.index());
                    } else {
                        lastTokenToEvaluate = c.index();
                        tokensToEvaluate.put(lastTokenToEvaluate, lastTokenToEvaluate);
                    }
                    lastNer = ner;
                }
                for (Integer index : tokensToEvaluate.keySet()) {
                    StringBuilder builder = new StringBuilder();
                    for (int i = index.intValue(); i <= (Integer)tokensToEvaluate.get(index); ++i) {
                        CoreLabel token = (CoreLabel)tokensIndex.get(i);
                        builder.append(token.word()).append(" ");
                    }
                    int start = (Integer)((CoreLabel)tokensIndex.get(index)).get(CoreAnnotations.CharacterOffsetBeginAnnotation.class);
                    int end = (Integer)((CoreLabel)tokensIndex.get(tokensToEvaluate.get(index))).get(CoreAnnotations.CharacterOffsetEndAnnotation.class);
                    String word = builder.toString().trim();
                    GeocodResult result = (GeocodResult)cache.get(word);
                    if (result == null) {
                        String response;
                        try {
                            response = this.request(word);
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                            continue;
                        }
                        JsonParser parser = new JsonParser();
                        JsonArray locations = (JsonArray)parser.parse(response);
                        if (locations.size() > 0) {
                            String lat = locations.get(0).getAsJsonObject().get("lat").getAsString();
                            String lon = locations.get(0).getAsJsonObject().get("lon").getAsString();
                            result = new GeocodResult(Double.parseDouble(lon), Double.parseDouble(lat), start, end);
                            if (this.setRaw) {
                                result.setRaw((JsonElement)locations);
                            }
                            result.setText(word);
                            cache.put(word, result);
                        }
                    }
                    if (result != null) {
                        res.add(result);
                        for (int i = index.intValue(); i <= (Integer)tokensToEvaluate.get(index); ++i) {
                            CoreLabel token = (CoreLabel)tokensIndex.get(i);
                            token.set(GeolocAnnotations.GeolocAnnotation.class, (Object)result);
                        }
                    }
                    try {
                        Thread.sleep(this.geoloc_conf.getTimeout().intValue());
                    }
                    catch (InterruptedException e) {
                        e.printStackTrace();
                    }
                }
            }
        }
        annotation.set(GeolocAnnotations.GeolocMultiAnnotation.class, res);
    }

    public Set<Annotator.Requirement> requirementsSatisfied() {
        return Collections.singleton(GeolocAnnotations.GEOLOC_ANNOTATION_REQUIREMENT);
    }

    public Set<Annotator.Requirement> requires() {
        return Collections.unmodifiableSet(new ArraySet((Object[])new Annotator.Requirement[]{NER_REQUIREMENT}));
    }
}

