/*
 * Decompiled with CFR 0.152.
 */
package eu.fbk.dh.tint.digimorph.annotator;

import com.google.common.base.Charsets;
import com.google.common.io.Resources;
import eu.fbk.dh.tint.digimorph.DigiMorph;
import eu.fbk.utils.core.FrequencyHashSet;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.net.URL;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.mapdb.SortedTableMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ModelHelper {
    private static final Logger LOGGER = LoggerFactory.getLogger(ModelHelper.class);

    public static void main(String[] args) {
        File conllFile = new File("/Volumes/Dati/Resources/ud-treebanks-v2.1/UD_Italian/it-ud-train.conllu");
        HashSet<String> detAdj = new HashSet<String>();
        URL adjResource = Resources.getResource((String)"det-adj.txt");
        try {
            for (String line : Resources.readLines((URL)adjResource, (Charset)Charsets.UTF_8)) {
                if ((line = line.trim()).length() == 0) continue;
                detAdj.add(line);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        DigiMorph digiMorph = new DigiMorph();
        HashMap<String, FrequencyHashSet> formToFeats = new HashMap<String, FrequencyHashSet>();
        HashMap formToForms = new HashMap();
        try {
            String line;
            BufferedReader reader = new BufferedReader(new FileReader(conllFile));
            ArrayList<String> forms = new ArrayList<String>();
            ArrayList<String> feats = new ArrayList<String>();
            while ((line = reader.readLine()) != null) {
                String[] parts;
                if ((line = line.trim()).startsWith("#") || (parts = line.split("\t")).length < 10) continue;
                forms.add(parts[1]);
                feats.add(parts[5]);
            }
            List morpho = digiMorph.getMorphology(forms);
            for (int i = 0; i < morpho.size(); ++i) {
                String mor = (String)morpho.get(i);
                String fea = (String)feats.get(i);
                String form = (String)forms.get(i);
                String[] words = mor.split("[\\s/]+");
                if (words.length > 2) continue;
                for (String word : words) {
                    String[] parts = word.split("\\+");
                    if (parts.length < 2 || detAdj.contains(parts[0])) continue;
                    String subToken = word.replaceAll("^[^~]*~", "");
                    subToken = subToken.replaceAll("^[^+]*\\+", "");
                    formToFeats.putIfAbsent(subToken, new FrequencyHashSet());
                    ((FrequencyHashSet)formToFeats.get(subToken)).add((Object)fea);
                    formToForms.putIfAbsent(subToken, new HashMap());
                    ((Map)formToForms.get(subToken)).putIfAbsent(form, new FrequencyHashSet());
                    ((FrequencyHashSet)((Map)formToForms.get(subToken)).get(form)).add((Object)fea);
                }
            }
            reader.close();
        }
        catch (Exception e) {
            e.printStackTrace();
            System.exit(1);
        }
        HashMap<String, String> uMap = new HashMap<String, String>();
        uMap.put("v", "VERB");
        uMap.put("adv", "ADV");
        uMap.put("adj", "ADJ");
        uMap.put("n", "NOUN");
        HashSet<String> featsList = new HashSet<String>();
        SortedTableMap map = digiMorph.getMap();
        Iterator gmIterator = map.keyIterator();
        while (gmIterator.hasNext()) {
            String[] words;
            String key = (String)gmIterator.next();
            String value = ((String)map.get((Object)key)).trim();
            for (String word : words = value.split("[\\s/]+")) {
                String ePos;
                String[] parts = word.split("\\+");
                if (parts.length < 2 || (ePos = parts[1]).length() == 0 || !uMap.keySet().contains(ePos)) continue;
                String subToken = word.replaceAll("^[^~]*~", "");
                subToken = subToken.replaceAll("^[^+]*\\+", "");
                featsList.add(subToken);
            }
        }
        for (String feats : featsList) {
            System.out.println(feats);
            if (formToFeats.get(feats) != null) {
                String mostFrequent = (String)((FrequencyHashSet)formToFeats.get(feats)).mostFrequent();
                System.out.println("Most frequent: " + mostFrequent);
                System.out.println("Frequency: " + ((FrequencyHashSet)formToFeats.get(feats)).get((Object)mostFrequent) + "/" + ((FrequencyHashSet)formToFeats.get(feats)).sum());
                System.out.println(formToFeats.get(feats));
                System.out.println(formToForms.get(feats));
            }
            System.out.println();
        }
    }
}

