/*
 * Decompiled with CFR 0.152.
 */
package eu.eventstorm.util;

import eu.eventstorm.util.Jvm;
import java.lang.reflect.Method;
import java.nio.ByteBuffer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class Buffers {
    private static final Logger LOGGER = LoggerFactory.getLogger(Buffers.class);
    private static final String JDK8_CLEANER = "sun.misc.Cleaner";
    private static final String JDK9_CLEANER = "jdk.internal.ref.Cleaner";
    private static final Class<? extends ByteBuffer> SUN_DIRECT_BUFFER = Buffers.lookupClassQuietly("sun.nio.ch.DirectBuffer");
    private static final Method SUN_BUFFER_CLEANER;
    private static final Method SUN_CLEANER_CLEAN;

    private Buffers() {
    }

    public static void releaseDirectByteBuffer(ByteBuffer buffer) {
        if (SUN_DIRECT_BUFFER != null && SUN_DIRECT_BUFFER.isAssignableFrom(buffer.getClass())) {
            try {
                Object cleaner = SUN_BUFFER_CLEANER.invoke((Object)buffer, (Object[])null);
                SUN_CLEANER_CLEAN.invoke(cleaner, (Object[])null);
            }
            catch (Exception cause) {
                LOGGER.warn("Failed to clean up Sun specific DirectByteBuffer. [{}]", (Object)cause.getMessage());
            }
        }
    }

    static Class<?> lookupClassQuietly(String fcqn) {
        try {
            return Class.forName(fcqn);
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException(e);
        }
    }

    static Method lookupMethodQuietly(Class<?> clazz, String method) {
        try {
            return clazz.getMethod(method, new Class[0]);
        }
        catch (NoSuchMethodException e) {
            throw new RuntimeException(e);
        }
    }

    static {
        Method bufferCleaner = null;
        Method cleanerClean = null;
        if (SUN_DIRECT_BUFFER != null) {
            bufferCleaner = Buffers.lookupMethodQuietly(SUN_DIRECT_BUFFER, "cleaner");
            cleanerClean = Jvm.isJava8() ? Buffers.lookupMethodQuietly(Buffers.lookupClassQuietly(JDK8_CLEANER), "clean") : Buffers.lookupMethodQuietly(Buffers.lookupClassQuietly(JDK9_CLEANER), "clean");
        }
        SUN_BUFFER_CLEANER = bufferCleaner;
        SUN_CLEANER_CLEAN = cleanerClean;
    }
}

