/*
 * Decompiled with CFR 0.152.
 */
package eu.eventstorm.util.tuple;

import eu.eventstorm.util.ToStringBuilder;
import eu.eventstorm.util.tuple.Tuple2;
import java.util.Objects;

final class Tuple2Impl<T1, T2>
implements Tuple2<T1, T2> {
    private final T1 t1;
    private final T2 t2;

    Tuple2Impl(T1 t1, T2 t2) {
        this.t1 = Objects.requireNonNull(t1, "t1 is null");
        this.t2 = Objects.requireNonNull(t2, "t2 is null");
    }

    @Override
    public T1 getT1() {
        return this.t1;
    }

    @Override
    public T2 getT2() {
        return this.t2;
    }

    public int hashCode() {
        return 31 * this.t1.hashCode() + this.t2.hashCode();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || !(obj instanceof Tuple2)) {
            return false;
        }
        Tuple2 other = (Tuple2)obj;
        return this.t1.equals(other.getT1()) && this.t2.equals(other.getT2());
    }

    public String toString() {
        return new ToStringBuilder(false).append("t1", this.t1).append("t2", this.t2).toString();
    }
}

