/*
 * Decompiled with CFR 0.152.
 */
package eu.eventstorm.util;

import eu.eventstorm.util.Ascii;
import eu.eventstorm.util.Strings;
import java.time.DateTimeException;
import java.time.LocalDate;
import java.time.LocalTime;
import java.time.OffsetDateTime;
import java.time.ZoneOffset;

public final class Dates {
    private static final int RADIX = 10;
    private static final char PLUS = '+';
    private static final char MINUS = '-';
    private static final char DATE_SEPARATOR = '-';
    private static final char SEPARATOR_T = 'T';
    private static final char TIME_SEPARATOR = ':';
    private static final char FRACTION_SEPARATOR = '.';
    private static final char ZULU = 'Z';

    private Dates() {
    }

    public static LocalDate parseLocalDate(String localDate) {
        if (Strings.isEmpty(localDate)) {
            throw new DateTimeException("The String is null or empty");
        }
        if (localDate.length() != 10) {
            throw new DateTimeException("Invalid LocalDate size (" + localDate.length() + ") [" + localDate + "]");
        }
        char[] chars = localDate.toCharArray();
        Dates.assertCharacter(chars, 4, '-');
        Dates.assertCharacter(chars, 7, '-');
        return LocalDate.of(Dates.parsePositiveInt(chars, 0, 4), Dates.parsePositiveInt(chars, 5, 7), Dates.parsePositiveInt(chars, 8, 10));
    }

    public static LocalTime parseLocalTime(String localTime) {
        if (Strings.isEmpty(localTime)) {
            throw new DateTimeException("The String is null or empty");
        }
        if (localTime.length() != 8) {
            throw new DateTimeException("Invalid LocalTime size (" + localTime.length() + ") [" + localTime + "]");
        }
        char[] chars = localTime.toCharArray();
        Dates.assertCharacter(chars, 2, ':');
        Dates.assertCharacter(chars, 5, ':');
        return LocalTime.of(Dates.parsePositiveInt(chars, 0, 2), Dates.parsePositiveInt(chars, 3, 5), Dates.parsePositiveInt(chars, 6, 8));
    }

    public static OffsetDateTime parseOffsetDateTime(String offsetDateTime) {
        if (Strings.isEmpty(offsetDateTime)) {
            throw new DateTimeException("The String is null or empty");
        }
        char[] chars = offsetDateTime.toCharArray();
        int year = Dates.parsePositiveInt(chars, 0, 4);
        Dates.assertCharacter(chars, 4, '-');
        int month = Dates.parsePositiveInt(chars, 5, 7);
        Dates.assertCharacter(chars, 7, '-');
        int day = Dates.parsePositiveInt(chars, 8, 10);
        Dates.assertCharacter(chars, 10, 'T');
        int hours = Dates.parsePositiveInt(chars, 11, 13);
        Dates.assertCharacter(chars, 13, ':');
        int minutes = Dates.parsePositiveInt(chars, 14, 16);
        if (chars[16] == ':') {
            return Dates.seconds(year, month, day, hours, minutes, chars);
        }
        if (chars[16] == 'Z' || chars[16] == '+' || chars[16] == '-') {
            return OffsetDateTime.of(year, month, day, hours, minutes, 0, 0, Dates.parseTimeZone(chars, 16));
        }
        throw new DateTimeException("Illegal character [" + chars[16] + "] at position " + 17 + " [" + new String(chars) + "]");
    }

    private static ZoneOffset parseTimeZone(char[] chars, int offset) {
        int remain = chars.length - offset;
        char sign = chars[offset];
        if (sign == 'Z') {
            if (remain != 1) {
                throw new DateTimeException("Found TimeZon 'Z' at position " + (offset + 1) + " but remain " + (remain - 1) + "after [" + new String(chars) + "]");
            }
            return ZoneOffset.UTC;
        }
        int hours = Dates.parsePositiveInt(chars, offset + 1, offset + 3);
        int minutes = Dates.parsePositiveInt(chars, offset + 4, offset + 4 + 2);
        if (sign == '-' && hours == 0 && minutes == 0) {
            throw new DateTimeException("Invalid TimeZone (-00:00)");
        }
        if (sign == '-') {
            hours = -hours;
            minutes = -minutes;
        }
        return ZoneOffset.ofHoursMinutes(hours, minutes);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static OffsetDateTime seconds(int year, int month, int day, int hour, int minute, char[] chars) {
        ZoneOffset offset;
        int second = Dates.parsePositiveInt(chars, 17, 19);
        int remain = chars.length - 19;
        if (remain == 0) {
            throw new DateTimeException("Missing TimeZone [" + new String(chars) + "]");
        }
        if (remain == 1) {
            if (chars[19] != 'Z') throw new DateTimeException("Invalid character at position 20 [" + new String(chars) + "]");
            return OffsetDateTime.of(year, month, day, hour, minute, second, 0, ZoneOffset.UTC);
        }
        int fractions = 0;
        if (chars[19] == '.') {
            int idx = Dates.indexOfNonDigit(chars, 20);
            if (idx == -1) throw new DateTimeException("Missing TimeZone [" + new String(chars) + "]");
            int len = idx - 20;
            fractions = Dates.getFractions(chars, idx, len);
            offset = Dates.parseTimeZone(chars, idx);
            return OffsetDateTime.of(year, month, day, hour, minute, second, fractions, offset);
        } else {
            if (chars[19] != '+' && chars[19] != '-') throw new DateTimeException("INVALID");
            offset = Dates.parseTimeZone(chars, 19);
        }
        return OffsetDateTime.of(year, month, day, hour, minute, second, fractions, offset);
    }

    private static int parsePositiveInt(char[] strNum, int startInclusive, int endExclusive) {
        if (endExclusive > strNum.length) {
            throw new DateTimeException("Unexpected end of expression at position " + strNum.length + " '" + new String(strNum) + "'");
        }
        int result = 0;
        for (int i = startInclusive; i < endExclusive; ++i) {
            if (!Ascii.isDigit(strNum[i])) {
                throw new DateTimeException("Character " + strNum[i] + " is not a digit");
            }
            int digit = Ascii.digit(strNum[i]);
            result *= 10;
            result -= digit;
        }
        return -result;
    }

    public static int indexOfNonDigit(char[] chars, int offset) {
        for (int i = offset; i < chars.length; ++i) {
            if (Ascii.isDigit(chars[i])) continue;
            return i;
        }
        return -1;
    }

    private static int getFractions(char[] chars, int idx, int len) {
        int fractions = Dates.parsePositiveInt(chars, 20, idx);
        switch (len) {
            case 1: {
                return fractions * 100000000;
            }
            case 2: {
                return fractions * 10000000;
            }
            case 3: {
                return fractions * 1000000;
            }
            case 4: {
                return fractions * 100000;
            }
            case 5: {
                return fractions * 10000;
            }
            case 6: {
                return fractions * 1000;
            }
            case 7: {
                return fractions * 100;
            }
            case 8: {
                return fractions * 10;
            }
        }
        return fractions;
    }

    private static void assertCharacter(char[] chars, int offset, char expected) {
        if (chars[offset] != expected) {
            throw new DateTimeException("Expected character [" + expected + "] at position " + (offset + 1) + " [" + new String(chars) + "]");
        }
    }
}

