/*
 * Decompiled with CFR 0.152.
 */
package eu.eventstorm.util;

import eu.eventstorm.util.Maths;
import eu.eventstorm.util.unsafe.UnsafeString;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.util.Arrays;

public final class ToStringBuilder {
    private static final int DEFAULT = 2048;
    private static final char[] NULL = new char[]{'n', 'u', 'l', 'l'};
    private static final char[] CLASS = new char[]{'c', 'l', 'a', 's', 's'};
    private static final char[] IDENTITY_HASH_CODE = new char[]{'i', 'd', 'e', 'n', 't', 'i', 't', 'y', 'H', 'a', 's', 'h', 'C', 'o', 'd', 'e'};
    private static final byte ASCII_CODE_0 = 48;
    private char[] value = new char[2048];
    private int idx;
    private final boolean appendNull;

    public ToStringBuilder(boolean appendNull) {
        this.value[0] = 123;
        this.idx = 1;
        this.appendNull = appendNull;
    }

    public ToStringBuilder(Object object) {
        this(object, true);
    }

    public ToStringBuilder(Object object, boolean appendNull) {
        this(appendNull);
        this.insertKey(CLASS);
        this.insertValue(UnsafeString.getChars(object.getClass().getSimpleName()));
        this.insertKey(IDENTITY_HASH_CODE);
        this.insertValue(UnsafeString.getChars(String.valueOf(System.identityHashCode(object))));
    }

    public ToStringBuilder append(String key, String value) {
        if (!this.appendNull && value == null) {
            return this;
        }
        this.insertKey(UnsafeString.getChars(key));
        if (value == null) {
            this.insertNullValue();
        } else {
            this.insertValue(UnsafeString.getChars(value));
        }
        return this;
    }

    public ToStringBuilder append(String key, char[] value) {
        if (!this.appendNull && value == null) {
            return this;
        }
        this.insertKey(UnsafeString.getChars(key));
        if (value == null) {
            this.insertNullValue();
        } else {
            this.insertValue(value);
        }
        return this;
    }

    public ToStringBuilder append(String key, Object value) {
        if (!this.appendNull && value == null) {
            return this;
        }
        this.insertKey(UnsafeString.getChars(key));
        if (value == null) {
            this.insertNullValue();
        } else if (value.getClass().isArray()) {
            this.insertRaw(UnsafeString.getChars(ToStringBuilder.toString((Object[])value)));
        } else if (Number.class.isAssignableFrom(value.getClass())) {
            this.insertRaw(UnsafeString.getChars(value.toString()));
        } else {
            this.insertValue(UnsafeString.getChars(value.toString()));
        }
        return this;
    }

    public ToStringBuilder append(String key, LocalDate value) {
        if (!this.appendNull && value == null) {
            return this;
        }
        this.insertKey(UnsafeString.getChars(key));
        if (value == null) {
            this.insertNullValue();
        } else {
            this.insertValue(value);
        }
        return this;
    }

    public ToStringBuilder append(String key, LocalTime value) {
        if (!this.appendNull && value == null) {
            return this;
        }
        this.insertKey(UnsafeString.getChars(key));
        if (value == null) {
            this.insertNullValue();
        } else {
            this.insertValue(value);
        }
        return this;
    }

    public ToStringBuilder append(String key, LocalDateTime value) {
        if (!this.appendNull && value == null) {
            return this;
        }
        this.insertKey(UnsafeString.getChars(key));
        if (value == null) {
            this.insertNullValue();
        } else {
            this.insertValue(value);
        }
        return this;
    }

    public String toString() {
        char[] v;
        int i = this.idx;
        if (this.value[i - 1] == ',') {
            v = new char[i];
            System.arraycopy(this.value, 0, v, 0, i - 1);
            v[i - 1] = 125;
        } else {
            v = new char[i + 1];
            System.arraycopy(this.value, 0, v, 0, i);
            v[i] = 125;
        }
        return UnsafeString.valueOf(v);
    }

    private void expandCapacity(int minimumCapacity) {
        int newCapacity = this.value.length + 1 << 1;
        if (newCapacity < 0) {
            newCapacity = Integer.MAX_VALUE;
        } else if (minimumCapacity > newCapacity) {
            newCapacity = minimumCapacity;
        }
        this.value = Arrays.copyOf(this.value, newCapacity);
    }

    private void insertKey(char[] value) {
        int index = this.idx;
        int len = value.length;
        int max = index + len + 3;
        if (max > this.value.length) {
            this.expandCapacity(max);
        }
        char[] val = this.value;
        val[index] = 34;
        System.arraycopy(value, 0, this.value, index + 1, len);
        val[max - 2] = 34;
        val[max - 1] = 58;
        this.idx = max;
    }

    private void insertValue(char[] value) {
        int len = value.length;
        int max = this.idx + len + 3;
        if (max > this.value.length) {
            this.expandCapacity(max);
        }
        char[] val = this.value;
        val[this.idx] = 34;
        System.arraycopy(value, 0, this.value, this.idx + 1, len);
        val[max - 2] = 34;
        val[max - 1] = 44;
        this.idx = max;
    }

    private void insertRaw(char[] value) {
        int len = value.length;
        int max = this.idx + len + 1;
        if (max > this.value.length) {
            this.expandCapacity(max);
        }
        char[] val = this.value;
        System.arraycopy(value, 0, this.value, this.idx, len);
        val[max - 1] = 44;
        this.idx = max;
    }

    private void insertValue(LocalDateTime dateTime) {
        int ptr = this.idx;
        int max = ptr + 24;
        if (max > this.value.length) {
            this.expandCapacity(max);
        }
        this.value[ptr++] = 91;
        ptr = ToStringBuilder.appendValue(this.value, ptr, dateTime.toLocalDate());
        this.value[ptr++] = 44;
        ptr = ToStringBuilder.appendValue(this.value, ptr, dateTime.toLocalTime());
        this.value[ptr++] = 93;
        this.value[ptr++] = 44;
        this.idx = ptr;
    }

    private void insertValue(LocalDate date) {
        int ptr = this.idx;
        if (ptr + 12 > this.value.length) {
            this.expandCapacity(ptr + 12);
        }
        this.value[ptr++] = 91;
        ptr = ToStringBuilder.appendValue(this.value, ptr, date);
        this.value[ptr++] = 93;
        this.value[ptr++] = 44;
        this.idx = ptr;
    }

    private void insertValue(LocalTime time) {
        int ptr = this.idx;
        if (ptr + 10 > this.value.length) {
            this.expandCapacity(ptr + 10);
        }
        this.value[ptr++] = 91;
        ptr = ToStringBuilder.appendValue(this.value, ptr, time);
        this.value[ptr++] = 93;
        this.value[ptr++] = 44;
        this.idx = ptr;
    }

    private void insertNullValue() {
        int max = this.idx + 5;
        if (max > this.value.length) {
            this.expandCapacity(max);
        }
        System.arraycopy(NULL, 0, this.value, this.idx, 4);
        this.value[max - 1] = 44;
        this.idx = max;
    }

    private static int appendValue(char[] val, int ptr, LocalDate date) {
        int year = date.getYear();
        val[ptr + 3] = (char)(48 + year % 10);
        year = Maths.unsignedDiv10(year);
        val[ptr + 2] = (char)(48 + year % 10);
        year = Maths.unsignedDiv10(year);
        val[ptr + 1] = (char)(48 + year % 10);
        val[ptr] = (char)(48 + Maths.unsignedDiv1000(date.getYear()));
        ptr += 4;
        val[ptr++] = 44;
        year = Maths.unsignedDiv10(date.getMonthValue());
        if (year != 0) {
            val[ptr++] = (char)(48 + year);
        }
        val[ptr++] = (char)(48 + date.getMonthValue() % 10);
        val[ptr++] = 44;
        year = Maths.unsignedDiv10(date.getDayOfMonth());
        if (year != 0) {
            val[ptr++] = (char)(48 + year);
        }
        val[ptr++] = (char)(48 + date.getDayOfMonth() % 10);
        return ptr;
    }

    private static int appendValue(char[] val, int ptr, LocalTime time) {
        int temp = Maths.unsignedDiv10(time.getHour());
        if (temp != 0) {
            val[ptr++] = (char)(48 + temp);
        }
        val[ptr++] = (char)(48 + time.getHour() % 10);
        val[ptr++] = 44;
        temp = Maths.unsignedDiv10(time.getMinute());
        if (temp != 0) {
            val[ptr++] = (char)(48 + temp);
        }
        val[ptr++] = (char)(48 + time.getMinute() % 10);
        val[ptr++] = 44;
        temp = Maths.unsignedDiv10(time.getSecond());
        if (temp != 0) {
            val[ptr++] = (char)(48 + temp);
        }
        val[ptr++] = (char)(48 + time.getSecond() % 10);
        return ptr;
    }

    private static String toString(Object[] a) {
        int iMax = a.length - 1;
        if (iMax == -1) {
            return "[]";
        }
        StringBuilder b = new StringBuilder();
        b.append('[');
        int i = 0;
        while (true) {
            if (a[i] instanceof Number) {
                b.append(String.valueOf(a[i]));
            } else {
                b.append('\"');
                b.append(String.valueOf(a[i]));
                b.append('\"');
            }
            if (i == iMax) {
                return b.append(']').toString();
            }
            b.append(",");
            ++i;
        }
    }
}

