/*
 * Decompiled with CFR 0.152.
 */
package eu.eventstorm.util.unsafe;

import com.sun.management.HotSpotDiagnosticMXBean;
import eu.eventstorm.util.unsafe.Architecture;
import java.io.IOException;
import java.lang.management.ManagementFactory;
import java.lang.reflect.Field;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import sun.misc.Unsafe;

public final class UnsafeHelper {
    private static final String HOTSPOT_BEAN_NAME = "com.sun.management:type=HotSpotDiagnostic";
    private static final Unsafe UNSAFE;
    private static final Architecture ARCH;
    private static HotSpotDiagnosticMXBean hotspotMBean;
    private static final long OBJECT_ARRAY_BASE;

    private UnsafeHelper() {
    }

    public static boolean getUseCompressedOopsVMOption() {
        return Boolean.valueOf(UnsafeHelper.getHotSpotMBean().getVMOption("UseCompressedOops").getValue());
    }

    public static int arrayCharBaseOffset() {
        return Unsafe.ARRAY_CHAR_BASE_OFFSET;
    }

    public static Unsafe getUnsafe() {
        return UNSAFE;
    }

    public static long toAddress(Object obj) {
        Object[] array = new Object[]{obj};
        switch (ARCH) {
            case X86: {
                return UnsafeHelper.normalize(UNSAFE.getInt(array, OBJECT_ARRAY_BASE));
            }
            case X64: {
                return UNSAFE.getLong(array, OBJECT_ARRAY_BASE);
            }
            case X64WITHCOMPRESSEDOOPS: {
                return UnsafeHelper.normalize(UNSAFE.getInt(array, OBJECT_ARRAY_BASE)) << 3;
            }
        }
        return UnsafeHelper.normalize(UNSAFE.getInt(array, OBJECT_ARRAY_BASE));
    }

    private static long normalize(int value) {
        return (long)value & 0xFFFFFFFFL;
    }

    public static long getFieldOffset(Class<?> clazz, String field) {
        try {
            return UNSAFE.objectFieldOffset(clazz.getDeclaredField(field));
        }
        catch (NoSuchFieldException | SecurityException e) {
            throw new RuntimeException(e);
        }
    }

    private static HotSpotDiagnosticMXBean getHotSpotMBean() {
        if (hotspotMBean == null) {
            try {
                hotspotMBean = ManagementFactory.newPlatformMXBeanProxy(ManagementFactory.getPlatformMBeanServer(), HOTSPOT_BEAN_NAME, HotSpotDiagnosticMXBean.class);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return hotspotMBean;
    }

    static {
        PrivilegedExceptionAction<Unsafe> action = new PrivilegedExceptionAction<Unsafe>(){

            @Override
            public Unsafe run() throws NoSuchFieldException, IllegalAccessException {
                Field theUnsafe = Unsafe.class.getDeclaredField("theUnsafe");
                theUnsafe.setAccessible(true);
                return (Unsafe)theUnsafe.get(null);
            }
        };
        try {
            UNSAFE = AccessController.doPrivileged(action);
        }
        catch (PrivilegedActionException cause) {
            throw new RuntimeException("Unable to load unsafe", cause);
        }
        String bits = System.getProperty("sun.arch.data.model");
        ARCH = bits.equals("32") ? Architecture.X86 : (bits.equals("64") && UnsafeHelper.getUseCompressedOopsVMOption() ? (Runtime.getRuntime().maxMemory() <= 2058354688L ? Architecture.X64WITH32BITCOMPRESSEDOOPS : Architecture.X64WITHCOMPRESSEDOOPS) : Architecture.X64);
        OBJECT_ARRAY_BASE = UNSAFE.arrayBaseOffset(Object[].class);
    }
}

