/*
 * Decompiled with CFR 0.152.
 */
package eu.eventstorm.util;

import java.io.InputStream;

public final class FastByteArrayInputStream
extends InputStream {
    private final byte[] hb;
    private final int limit;
    private int pos;

    public FastByteArrayInputStream(byte[] hb, int limit) {
        this.hb = hb;
        this.pos = 0;
        this.limit = limit;
    }

    public FastByteArrayInputStream(byte[] hb) {
        this(hb, hb.length);
    }

    @Override
    public int read() {
        if (this.pos == this.limit) {
            return -1;
        }
        return this.hb[this.pos++] & 0xFF;
    }

    @Override
    public int read(byte[] b) {
        return this.read(b, 0, b.length);
    }

    @Override
    public int read(byte[] b, int off, int len) {
        if (this.limit == this.pos) {
            return -1;
        }
        if (len < this.limit - this.pos) {
            System.arraycopy(this.hb, this.pos, b, off, len);
            this.pos += len;
            return len;
        }
        System.arraycopy(this.hb, this.pos, b, off, this.available());
        int oldPso = this.pos;
        this.pos = this.limit;
        return this.limit - oldPso;
    }

    @Override
    public void reset() {
        this.pos = 0;
    }

    @Override
    public int available() {
        return this.limit - this.pos;
    }

    public int pos() {
        return this.pos;
    }

    @Override
    public void close() {
    }

    public byte[] readAll() {
        byte[] bytes = new byte[this.limit - this.pos];
        System.arraycopy(this.hb, this.pos, bytes, 0, this.limit - this.pos);
        this.pos = this.limit;
        return bytes;
    }

    public int size() {
        return this.limit;
    }
}

