/*
 * Decompiled with CFR 0.152.
 */
package eu.eventstorm.util;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;

public final class Jvm {
    private static final int JVM_VERSION = Jvm.getVersion();
    private static final boolean IS_JAVA_9_OR_PLUS = JVM_VERSION > 8;

    private Jvm() {
    }

    public static boolean isJava8() {
        return JVM_VERSION == 8;
    }

    public static boolean isJava9OrPlus() {
        return IS_JAVA_9_OR_PLUS;
    }

    private static int getVersion() {
        try {
            Method method = Runtime.class.getDeclaredMethod("version", new Class[0]);
            if (method != null) {
                Object version = method.invoke((Object)Runtime.getRuntime(), new Object[0]);
                Class<?> clz = Class.forName("java.lang.Runtime$Version");
                return (Integer)clz.getDeclaredMethod("major", new Class[0]).invoke(version, new Object[0]);
            }
        }
        catch (ClassNotFoundException | IllegalAccessException | NoSuchMethodException | InvocationTargetException reflectiveOperationException) {
            // empty catch block
        }
        return Integer.parseInt(Runtime.class.getPackage().getSpecificationVersion().split("\\.")[1]);
    }
}

