/*
 * Decompiled with CFR 0.152.
 */
package eu.eventstorm.util;

import eu.eventstorm.util.FastByteArrayInputStream;
import java.io.OutputStream;

public final class FastByteArrayOutputStream
extends OutputStream {
    private static final int TWO = 2;
    private byte[] hb;
    private int pos = 0;

    public FastByteArrayOutputStream(int initSize) {
        this.hb = new byte[initSize];
    }

    private void verifyBufferSize(int sz) {
        if (sz > this.hb.length) {
            byte[] old = this.hb;
            this.hb = new byte[Math.max(sz, this.hb.length << 2)];
            System.arraycopy(old, 0, this.hb, 0, old.length);
        }
    }

    public byte[] getByteArray() {
        byte[] buf = new byte[this.pos];
        System.arraycopy(this.hb, 0, buf, 0, this.pos);
        return buf;
    }

    @Override
    public void write(int b) {
        this.verifyBufferSize(this.pos + 1);
        this.hb[this.pos] = (byte)b;
        ++this.pos;
    }

    @Override
    public void write(byte[] b) {
        this.verifyBufferSize(this.pos + b.length);
        System.arraycopy(b, 0, this.hb, this.pos, b.length);
        this.pos += b.length;
    }

    @Override
    public void write(byte[] b, int off, int len) {
        this.verifyBufferSize(this.pos + len);
        System.arraycopy(b, off, this.hb, this.pos, len);
        this.pos += len;
    }

    public int size() {
        return this.pos;
    }

    public void reset() {
        this.pos = 0;
    }

    @Override
    public void close() {
    }

    public FastByteArrayInputStream toInputStream() {
        return new FastByteArrayInputStream(this.hb, this.pos);
    }
}

