/*
 * Decompiled with CFR 0.152.
 */
package eu.eventstorm.batch.db;

import eu.eventstorm.batch.db.BatchExecution;
import eu.eventstorm.batch.db.BatchExecutionImpl;
import eu.eventstorm.sql.Dialect;
import eu.eventstorm.sql.jdbc.Mapper;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;

final class BatchExecutionMapper
implements Mapper<BatchExecution> {
    BatchExecutionMapper() {
    }

    public BatchExecution map(Dialect dialect, ResultSet rs) throws SQLException {
        BatchExecutionImpl pojo = new BatchExecutionImpl();
        pojo.setId(rs.getLong(1));
        pojo.setUuid(rs.getString(2));
        pojo.setResource(rs.getString(3));
        pojo.setName(rs.getString(4));
        pojo.setStatus(rs.getByte(5));
        pojo.setCreatedAt(rs.getTimestamp(6));
        pojo.setStartedAt(rs.getTimestamp(7));
        pojo.setEndedAt(rs.getTimestamp(8));
        pojo.setLog(dialect.fromJdbcJson(rs, 9));
        return pojo;
    }

    public void insert(PreparedStatement ps, BatchExecution pojo) throws SQLException {
        ps.setLong(1, pojo.getId());
        ps.setString(2, pojo.getUuid());
        ps.setString(3, pojo.getResource());
        ps.setString(4, pojo.getName());
        ps.setByte(5, pojo.getStatus());
        ps.setTimestamp(6, pojo.getCreatedAt());
        if (pojo.getStartedAt() != null) {
            ps.setTimestamp(7, pojo.getStartedAt());
        } else {
            ps.setNull(7, 93);
        }
        if (pojo.getEndedAt() != null) {
            ps.setTimestamp(8, pojo.getEndedAt());
        } else {
            ps.setNull(8, 93);
        }
        pojo.getLog().flush();
        ps.setObject(9, pojo.getLog());
    }

    public void update(PreparedStatement ps, BatchExecution pojo) throws SQLException {
        ps.setString(1, pojo.getUuid());
        ps.setString(2, pojo.getResource());
        ps.setString(3, pojo.getName());
        ps.setByte(4, pojo.getStatus());
        ps.setTimestamp(5, pojo.getCreatedAt());
        if (pojo.getStartedAt() != null) {
            ps.setTimestamp(6, pojo.getStartedAt());
        } else {
            ps.setNull(6, 93);
        }
        if (pojo.getEndedAt() != null) {
            ps.setTimestamp(7, pojo.getEndedAt());
        } else {
            ps.setNull(7, 93);
        }
        pojo.getLog().flush();
        ps.setObject(8, pojo.getLog());
        ps.setLong(9, pojo.getId());
    }
}

