/*
 * Decompiled with CFR 0.152.
 */
package eu.eventstorm.batch.db;

import eu.eventstorm.batch.db.BatchExecution;
import eu.eventstorm.batch.db.BatchExecutionDescriptor;
import eu.eventstorm.batch.db.Mappers;
import eu.eventstorm.sql.Database;
import eu.eventstorm.sql.Repository;
import eu.eventstorm.sql.SqlQuery;
import eu.eventstorm.sql.desc.SqlColumn;
import eu.eventstorm.sql.desc.SqlTable;
import eu.eventstorm.sql.expression.Expressions;
import eu.eventstorm.sql.jdbc.Batch;
import eu.eventstorm.sql.jdbc.InsertMapper;
import eu.eventstorm.sql.jdbc.ResultSetMapper;
import eu.eventstorm.sql.jdbc.UpdateMapper;
import java.sql.Timestamp;

public abstract class AbstractBatchExecutionRepository
extends Repository {
    private final SqlQuery findById = (SqlQuery)this.select(BatchExecutionDescriptor.ALL).from(new SqlTable[]{BatchExecutionDescriptor.TABLE}).where(Expressions.eq((SqlColumn)BatchExecutionDescriptor.ID)).build();
    private final SqlQuery findByIdForUpdate = (SqlQuery)this.select(BatchExecutionDescriptor.ALL).from(new SqlTable[]{BatchExecutionDescriptor.TABLE}).where(Expressions.eq((SqlColumn)BatchExecutionDescriptor.ID)).forUpdate().build();
    private final SqlQuery delete;
    private final SqlQuery update;
    private final SqlQuery insert = this.insert(BatchExecutionDescriptor.TABLE, BatchExecutionDescriptor.IDS, BatchExecutionDescriptor.COLUMNS).build();

    protected AbstractBatchExecutionRepository(Database database) {
        super(database);
        this.update = this.update(BatchExecutionDescriptor.TABLE, BatchExecutionDescriptor.COLUMNS, BatchExecutionDescriptor.IDS).build();
        this.delete = this.delete(BatchExecutionDescriptor.TABLE).where(Expressions.eq((SqlColumn)BatchExecutionDescriptor.ID)).build();
    }

    public final BatchExecution findById(long id) {
        return (BatchExecution)this.executeSelect(this.findById, ps -> ps.setLong(1, id), (ResultSetMapper)Mappers.BATCH_EXECUTION);
    }

    public final BatchExecution findByIdForUpdate(long id) {
        return (BatchExecution)this.executeSelect(this.findByIdForUpdate, ps -> ps.setLong(1, id), (ResultSetMapper)Mappers.BATCH_EXECUTION);
    }

    public final void insert(BatchExecution pojo) {
        pojo.setCreatedAt(new Timestamp(System.currentTimeMillis()));
        this.executeInsert(this.insert, (InsertMapper)Mappers.BATCH_EXECUTION, pojo);
    }

    public final void update(BatchExecution pojo) {
        this.executeUpdate(this.update, (UpdateMapper)Mappers.BATCH_EXECUTION, pojo);
    }

    public final Batch<BatchExecution> batch() {
        return this.batch(this.insert, (InsertMapper)Mappers.BATCH_EXECUTION);
    }
}

