/*
 * Decompiled with CFR 0.152.
 */
package eu.eventstorm.batch.db;

import eu.eventstorm.batch.db.DatabaseResource;
import eu.eventstorm.batch.db.DatabaseResourceDescriptor;
import eu.eventstorm.batch.db.Mappers;
import eu.eventstorm.sql.Database;
import eu.eventstorm.sql.Repository;
import eu.eventstorm.sql.SqlQuery;
import eu.eventstorm.sql.desc.SqlColumn;
import eu.eventstorm.sql.desc.SqlTable;
import eu.eventstorm.sql.expression.Expressions;
import eu.eventstorm.sql.jdbc.Batch;
import eu.eventstorm.sql.jdbc.InsertMapper;
import eu.eventstorm.sql.jdbc.ResultSetMapper;
import eu.eventstorm.sql.jdbc.UpdateMapper;

public abstract class AbstractDatabaseResourceRepository
extends Repository {
    private final SqlQuery findById = (SqlQuery)this.select(DatabaseResourceDescriptor.ALL).from(new SqlTable[]{DatabaseResourceDescriptor.TABLE}).where(Expressions.eq((SqlColumn)DatabaseResourceDescriptor.ID)).build();
    private final SqlQuery findByIdForUpdate = (SqlQuery)this.select(DatabaseResourceDescriptor.ALL).from(new SqlTable[]{DatabaseResourceDescriptor.TABLE}).where(Expressions.eq((SqlColumn)DatabaseResourceDescriptor.ID)).forUpdate().build();
    private final SqlQuery delete;
    private final SqlQuery update;
    private final SqlQuery insert = this.insert(DatabaseResourceDescriptor.TABLE, DatabaseResourceDescriptor.IDS, DatabaseResourceDescriptor.COLUMNS).build();

    protected AbstractDatabaseResourceRepository(Database database) {
        super(database);
        this.update = this.update(DatabaseResourceDescriptor.TABLE, DatabaseResourceDescriptor.COLUMNS, DatabaseResourceDescriptor.IDS).build();
        this.delete = this.delete(DatabaseResourceDescriptor.TABLE).where(Expressions.eq((SqlColumn)DatabaseResourceDescriptor.ID)).build();
    }

    public final DatabaseResource findById(String id) {
        return (DatabaseResource)this.executeSelect(this.findById, ps -> ps.setString(1, id), (ResultSetMapper)Mappers.DATABASE_RESOURCE);
    }

    public final DatabaseResource findByIdForUpdate(String id) {
        return (DatabaseResource)this.executeSelect(this.findByIdForUpdate, ps -> ps.setString(1, id), (ResultSetMapper)Mappers.DATABASE_RESOURCE);
    }

    public final void insert(DatabaseResource pojo) {
        this.executeInsert(this.insert, (InsertMapper)Mappers.DATABASE_RESOURCE, pojo);
    }

    public final void update(DatabaseResource pojo) {
        this.executeUpdate(this.update, (UpdateMapper)Mappers.DATABASE_RESOURCE, pojo);
    }

    public final Batch<DatabaseResource> batch() {
        return this.batch(this.insert, (InsertMapper)Mappers.DATABASE_RESOURCE);
    }

    public final void delete(String id) {
        this.executeDelete(this.delete, ps -> ps.setString(1, id));
    }
}

