/*
 * Decompiled with CFR 0.152.
 */
package eu.eventstorm.batch.db;

import eu.eventstorm.batch.db.DatabaseExecution;
import eu.eventstorm.batch.db.DatabaseExecutionDescriptor;
import eu.eventstorm.batch.db.Mappers;
import eu.eventstorm.sql.Database;
import eu.eventstorm.sql.Repository;
import eu.eventstorm.sql.SqlQuery;
import eu.eventstorm.sql.desc.SqlColumn;
import eu.eventstorm.sql.desc.SqlTable;
import eu.eventstorm.sql.expression.Expressions;
import eu.eventstorm.sql.jdbc.Batch;
import eu.eventstorm.sql.jdbc.InsertMapper;
import eu.eventstorm.sql.jdbc.ResultSetMapper;
import eu.eventstorm.sql.jdbc.UpdateMapper;
import java.sql.Timestamp;

public abstract class AbstractDatabaseExecutionRepository
extends Repository {
    private final SqlQuery findById = (SqlQuery)this.select(DatabaseExecutionDescriptor.ALL).from(new SqlTable[]{DatabaseExecutionDescriptor.TABLE}).where(Expressions.eq((SqlColumn)DatabaseExecutionDescriptor.ID)).build();
    private final SqlQuery findByIdForUpdate = (SqlQuery)this.select(DatabaseExecutionDescriptor.ALL).from(new SqlTable[]{DatabaseExecutionDescriptor.TABLE}).where(Expressions.eq((SqlColumn)DatabaseExecutionDescriptor.ID)).forUpdate().build();
    private final SqlQuery delete;
    private final SqlQuery update;
    private final SqlQuery insert = this.insert(DatabaseExecutionDescriptor.TABLE, DatabaseExecutionDescriptor.IDS, DatabaseExecutionDescriptor.COLUMNS).build();

    protected AbstractDatabaseExecutionRepository(Database database) {
        super(database);
        this.update = this.update(DatabaseExecutionDescriptor.TABLE, DatabaseExecutionDescriptor.COLUMNS, DatabaseExecutionDescriptor.IDS).build();
        this.delete = this.delete(DatabaseExecutionDescriptor.TABLE).where(Expressions.eq((SqlColumn)DatabaseExecutionDescriptor.ID)).build();
    }

    public final DatabaseExecution findById(long id) {
        return (DatabaseExecution)this.executeSelect(this.findById, ps -> ps.setLong(1, id), (ResultSetMapper)Mappers.DATABASE_EXECUTION);
    }

    public final DatabaseExecution findByIdForUpdate(long id) {
        return (DatabaseExecution)this.executeSelect(this.findByIdForUpdate, ps -> ps.setLong(1, id), (ResultSetMapper)Mappers.DATABASE_EXECUTION);
    }

    public final void insert(DatabaseExecution pojo) {
        pojo.setCreatedAt(new Timestamp(System.currentTimeMillis()));
        this.executeInsert(this.insert, (InsertMapper)Mappers.DATABASE_EXECUTION, pojo);
    }

    public final void update(DatabaseExecution pojo) {
        this.executeUpdate(this.update, (UpdateMapper)Mappers.DATABASE_EXECUTION, pojo);
    }

    public final Batch<DatabaseExecution> batch() {
        return this.batch(this.insert, (InsertMapper)Mappers.DATABASE_EXECUTION);
    }

    public final void delete(long id) {
        this.executeDelete(this.delete, ps -> ps.setLong(1, id));
    }
}

