package eu.eventstorm.batch.db;

import static eu.eventstorm.batch.db.DatabaseResourceDescriptor.ALL;
import static eu.eventstorm.batch.db.DatabaseResourceDescriptor.IDS;
import static eu.eventstorm.batch.db.DatabaseResourceDescriptor.COLUMNS;
import static eu.eventstorm.batch.db.DatabaseResourceDescriptor.TABLE;
import eu.eventstorm.sql.SqlQuery;
import static eu.eventstorm.batch.db.DatabaseResourceDescriptor.ID;
import static eu.eventstorm.sql.expression.Expressions.eq;
import static eu.eventstorm.sql.expression.Expressions.and;

import javax.annotation.Generated;

@Generated("eu.eventsotrm.sql.apt.RepositoryGenerator")
public abstract class AbstractDatabaseResourceRepository extends eu.eventstorm.sql.Repository {

    private final SqlQuery findById;
    private final SqlQuery findByIdForUpdate;
    private final SqlQuery delete;
    private final SqlQuery update;
    private final SqlQuery insert;

    protected AbstractDatabaseResourceRepository(eu.eventstorm.sql.Database database){
        super(database);
        this.findById = select(ALL).from(TABLE).where(eq(ID)).build();
        this.findByIdForUpdate = select(ALL).from(TABLE).where(eq(ID)).forUpdate().build();
        this.insert = insert(TABLE, IDS, COLUMNS).build();
        this.update = update(TABLE, COLUMNS, IDS).build();
        this.delete = delete(TABLE).where(eq(ID)).build();
    }

    public final eu.eventstorm.batch.db.DatabaseResource findById(java.lang.String id) {
        return executeSelect(this.findById, ps -> {
           ps.setString(1, id);
        }, Mappers.DATABASE_RESOURCE);
    }

    public final eu.eventstorm.batch.db.DatabaseResource findByIdForUpdate(java.lang.String id) {
        return executeSelect(this.findByIdForUpdate, ps -> ps.setString(1, id), Mappers.DATABASE_RESOURCE);
    }

    public final void insert(eu.eventstorm.batch.db.DatabaseResource pojo) {
        // execute insert
        executeInsert(this.insert, Mappers.DATABASE_RESOURCE, pojo);
    }

    public final void update(eu.eventstorm.batch.db.DatabaseResource pojo) {
        // execute update
        executeUpdate(this.update, Mappers.DATABASE_RESOURCE, pojo);
    }

    public final eu.eventstorm.sql.jdbc.Batch<eu.eventstorm.batch.db.DatabaseResource> batch() {
        return batch(this.insert, Mappers.DATABASE_RESOURCE);
    }

    public final void delete(java.lang.String id) {
        executeDelete(this.delete, ps -> {
            ps.setString(1,id);
        });
    }
}