package eu.eventstorm.batch.db;

import static eu.eventstorm.batch.db.DatabaseExecutionDescriptor.ALL;
import static eu.eventstorm.batch.db.DatabaseExecutionDescriptor.IDS;
import static eu.eventstorm.batch.db.DatabaseExecutionDescriptor.COLUMNS;
import static eu.eventstorm.batch.db.DatabaseExecutionDescriptor.TABLE;
import eu.eventstorm.sql.SqlQuery;
import static eu.eventstorm.batch.db.DatabaseExecutionDescriptor.ID;
import static eu.eventstorm.sql.expression.Expressions.eq;
import static eu.eventstorm.sql.expression.Expressions.and;

import javax.annotation.Generated;

@Generated("eu.eventsotrm.sql.apt.RepositoryGenerator")
public abstract class AbstractDatabaseExecutionRepository extends eu.eventstorm.sql.Repository {

    private final SqlQuery findById;
    private final SqlQuery findByIdForUpdate;
    private final SqlQuery delete;
    private final SqlQuery update;
    private final SqlQuery insert;

    protected AbstractDatabaseExecutionRepository(eu.eventstorm.sql.Database database){
        super(database);
        this.findById = select(ALL).from(TABLE).where(eq(ID)).build();
        this.findByIdForUpdate = select(ALL).from(TABLE).where(eq(ID)).forUpdate().build();
        this.insert = insert(TABLE, IDS, COLUMNS).build();
        this.update = update(TABLE, COLUMNS, IDS).build();
        this.delete = delete(TABLE).where(eq(ID)).build();
    }

    public final eu.eventstorm.batch.db.DatabaseExecution findById(long id) {
        return executeSelect(this.findById, ps -> {
           ps.setLong(1, id);
        }, Mappers.DATABASE_EXECUTION);
    }

    public final eu.eventstorm.batch.db.DatabaseExecution findByIdForUpdate(long id) {
        return executeSelect(this.findByIdForUpdate, ps -> ps.setLong(1, id), Mappers.DATABASE_EXECUTION);
    }

    public final void insert(eu.eventstorm.batch.db.DatabaseExecution pojo) {
        // set create timestamp
        pojo.setCreatedAt(new java.sql.Timestamp(System.currentTimeMillis()));

        // execute insert
        executeInsert(this.insert, Mappers.DATABASE_EXECUTION, pojo);
    }

    public final void update(eu.eventstorm.batch.db.DatabaseExecution pojo) {
        // execute update
        executeUpdate(this.update, Mappers.DATABASE_EXECUTION, pojo);
    }

    public final eu.eventstorm.sql.jdbc.Batch<eu.eventstorm.batch.db.DatabaseExecution> batch() {
        return batch(this.insert, Mappers.DATABASE_EXECUTION);
    }

    public final void delete(long id) {
        executeDelete(this.delete, ps -> {
            ps.setLong(1,id);
        });
    }
}