/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.thumbnail.web;

import com.amazonaws.services.s3.model.ObjectMetadata;
import eu.europeana.thumbnail.model.ImageSize;
import eu.europeana.thumbnail.model.MediaStream;
import eu.europeana.thumbnail.service.StoragesService;
import eu.europeana.thumbnail.web.AbstractController;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import jakarta.validation.constraints.Pattern;
import java.io.InputStream;
import java.util.Optional;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.core.io.InputStreamResource;
import org.springframework.http.ResponseEntity;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.context.request.WebRequest;

@RestController
@Validated
public class ThumbnailControllerV2
extends AbstractController {
    private static final Logger LOG = LogManager.getLogger(ThumbnailControllerV2.class);
    private static final int CONTENT_LENGTH_IMAGE_ICON = 2319;
    private static final int CONTENT_LENGTH_SOUND_ICON = 2484;
    private static final int CONTENT_LENGTH_VIDEO_ICON = 1932;
    private static final int CONTENT_LENGTH_TEXT_ICON = 2180;
    private static final int CONTENT_LENGTH_3D_ICON = 3012;
    protected static final String INVALID_URL_MESSAGE = "INVALID URL";

    public ThumbnailControllerV2(StoragesService storagesService) {
        super(storagesService);
    }

    @GetMapping(value={"/api/v2/thumbnail-by-url.json", "/thumbnail/v2/url.json"})
    public ResponseEntity<InputStreamResource> thumbnailByUrlV2(@RequestParam(value="uri") @Pattern(regexp="^((https?|ftp)://|urn:).*$", message="INVALID URL") @Pattern(regexp="^((https?|ftp)://|urn:).*$", message="INVALID URL") String url, @RequestParam(value="size", required=false, defaultValue="w400") String size, @RequestParam(value="type", required=false, defaultValue="IMAGE") String type, WebRequest webRequest, HttpServletRequest request, HttpServletResponse response) {
        Optional mediaFile;
        long startTime = 0L;
        if (LOG.isDebugEnabled()) {
            startTime = System.nanoTime();
            LOG.debug("Url = {}, size = {}, type = {}", (Object)url, (Object)size, (Object)type);
        }
        ResponseEntity result = (mediaFile = this.retrieveThumbnail(request, null, url, Integer.valueOf(this.getWidth(size)))).isEmpty() ? this.generateResponse(webRequest, response, this.getDefaultThumbnailForNotFoundResourceByType(type)) : this.generateResponse(webRequest, response, (MediaStream)mediaFile.get());
        this.logRequestDuration(startTime, "Url = " + url + ", status = " + response.getStatus());
        return result;
    }

    private int getWidth(String size) {
        if (StringUtils.equalsIgnoreCase((CharSequence)size, (CharSequence)"w200") || StringUtils.equalsIgnoreCase((CharSequence)size, (CharSequence)"200")) {
            return ImageSize.MEDIUM.getWidth();
        }
        return ImageSize.LARGE.getWidth();
    }

    private MediaStream getDefaultThumbnailForNotFoundResourceByType(String type) {
        String defaultImageName;
        ObjectMetadata metadata = new ObjectMetadata();
        switch (StringUtils.upperCase((String)type)) {
            case "IMAGE": {
                defaultImageName = "EU_thumbnails_image.png";
                metadata.setContentLength(2319L);
                break;
            }
            case "SOUND": {
                defaultImageName = "EU_thumbnails_sound.png";
                metadata.setContentLength(2484L);
                break;
            }
            case "VIDEO": {
                defaultImageName = "EU_thumbnails_video.png";
                metadata.setContentLength(1932L);
                break;
            }
            case "TEXT": {
                defaultImageName = "EU_thumbnails_text.png";
                metadata.setContentLength(2180L);
                break;
            }
            case "3D": {
                defaultImageName = "EU_thumbnails_3d.png";
                metadata.setContentLength(3012L);
                break;
            }
            default: {
                defaultImageName = "EU_thumbnails_image.png";
                metadata.setContentLength(2319L);
            }
        }
        InputStream stream = this.getClass().getResourceAsStream("/images/" + defaultImageName);
        return new MediaStream(null, defaultImageName, stream, metadata);
    }
}

