/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.thumbnail.web;

import eu.europeana.thumbnail.model.ImageSize;
import eu.europeana.thumbnail.model.MediaStream;
import eu.europeana.thumbnail.service.MediaStorageService;
import eu.europeana.thumbnail.service.StoragesService;
import eu.europeana.thumbnail.utils.ControllerUtils;
import eu.europeana.thumbnail.utils.HashUtils;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.util.List;
import java.util.Locale;
import java.util.Optional;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.core.io.InputStreamResource;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.lang.NonNull;
import org.springframework.web.context.request.WebRequest;

public abstract class AbstractController {
    private static final Logger LOG = LogManager.getLogger(AbstractController.class);
    private static final long DURATION_CONVERTER = 1000000L;
    protected StoragesService storagesService;

    protected AbstractController(StoragesService storagesService) {
        this.storagesService = storagesService;
    }

    protected Optional<MediaStream> retrieveThumbnail(HttpServletRequest request, String fileId, String originalUrl, Integer width) {
        String id = fileId;
        if (StringUtils.isEmpty((CharSequence)fileId)) {
            id = this.computeId(originalUrl);
        }
        id = this.addWidth(id, width);
        Object serverName = request.getServerName();
        if ("localhost".equalsIgnoreCase((String)serverName)) {
            serverName = (String)serverName + ":" + request.getServerPort();
        }
        MediaStream result = null;
        List mediaStorageServices = this.storagesService.getStorages((String)serverName);
        for (MediaStorageService mss : mediaStorageServices) {
            result = mss.retrieve(id, originalUrl);
            if (result == null) {
                LOG.debug("File {} not present in storage {}", (Object)id, (Object)mss.getName());
                continue;
            }
            LOG.debug("File {} found in storage {}", (Object)id, (Object)mss.getName());
            if (!"uim-prod".equals(mss.getName())) break;
            LOG.debug("File with url {} and id {} found in old Amazon S3 storage", (Object)originalUrl, (Object)id);
            break;
        }
        return Optional.ofNullable(result);
    }

    private String computeId(String resourceUrl) {
        return HashUtils.getMD5((String)resourceUrl);
    }

    private String addWidth(String id, Integer resourceWidth) {
        String width = ImageSize.LARGE.name();
        if (resourceWidth != null && resourceWidth.intValue() == ImageSize.MEDIUM.getWidth()) {
            width = ImageSize.MEDIUM.name();
        }
        return id + "-" + width;
    }

    protected ResponseEntity<InputStreamResource> generateResponse(WebRequest webRequest, HttpServletResponse response, @NonNull MediaStream mediaFile) {
        ControllerUtils.addDefaultResponseHeaders((HttpServletResponse)response);
        if (ControllerUtils.checkForNotModified((MediaStream)mediaFile, (WebRequest)webRequest)) {
            mediaFile.close();
            return null;
        }
        if (ControllerUtils.checkForPrecondition((MediaStream)mediaFile, (WebRequest)webRequest)) {
            mediaFile.close();
            response.setStatus(HttpStatus.PRECONDITION_FAILED.value());
            return null;
        }
        InputStreamResource result = new InputStreamResource(mediaFile.getInputStream());
        MediaType mediaType = this.getMediaType(mediaFile.getOriginalUrl());
        if (mediaFile.hasMetadata()) {
            return ResponseEntity.ok().contentType(mediaType).contentLength(mediaFile.getContentLength()).body((Object)result);
        }
        return ResponseEntity.ok().contentType(mediaType).body((Object)result);
    }

    private MediaType getMediaType(String url) {
        if (url == null) {
            return MediaType.IMAGE_JPEG;
        }
        String urlLow = url.toLowerCase(Locale.GERMAN);
        if (urlLow.endsWith(".png") || urlLow.endsWith(".pdf")) {
            return MediaType.IMAGE_PNG;
        }
        return MediaType.IMAGE_JPEG;
    }

    protected void logRequestDuration(long startTime, String requestInfo) {
        if (LOG.isDebugEnabled()) {
            Long duration = (System.nanoTime() - startTime) / 1000000L;
            if (StringUtils.isBlank((CharSequence)requestInfo)) {
                LOG.debug("Processing time = {} ms ", (Object)duration);
            } else {
                LOG.debug("{}, processing time = {} ms ", (Object)requestInfo, (Object)duration);
            }
        }
    }
}

