/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.thumbnail.utils;

import eu.europeana.thumbnail.model.MediaStream;
import jakarta.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.springframework.web.context.request.WebRequest;

/*
 * Exception performing whole class analysis ignored.
 */
public final class ControllerUtils {
    private static final String ALLOW_VALUE = "GET, HEAD";
    private static final String CACHE_CONTROL_VALUE = "public, max-age=604800, must-revalidate";
    private static final String IFMATCH = "If-Match";
    private static final String ANY = "*";
    private static final String GZIPSUFFIX = "-gzip";

    private ControllerUtils() {
    }

    public static void addDefaultResponseHeaders(HttpServletResponse response) {
        response.addHeader("Allow", "GET, HEAD");
        response.addHeader("Cache-Control", "public, max-age=604800, must-revalidate");
    }

    public static boolean checkForPrecondition(MediaStream mediaFile, WebRequest webRequest) {
        return StringUtils.isNotBlank((CharSequence)webRequest.getHeader("If-Match")) && !ControllerUtils.doesAnyETagMatch((String)webRequest.getHeader("If-Match"), (String)mediaFile.getETag());
    }

    public static boolean checkForNotModified(MediaStream mediaFile, WebRequest webRequest) {
        if (mediaFile.getLastModified() != null && mediaFile.getETag() != null) {
            return webRequest.checkNotModified(StringUtils.removeEndIgnoreCase((String)mediaFile.getETag(), (String)"-gzip"), mediaFile.getLastModified().getMillis());
        }
        return mediaFile.getETag() != null && webRequest.checkNotModified(StringUtils.removeEndIgnoreCase((String)mediaFile.getETag(), (String)"-gzip"));
    }

    private static boolean doesAnyETagMatch(String eTags, String eTagToMatch) {
        if (StringUtils.equals((CharSequence)"*", (CharSequence)eTags)) {
            return true;
        }
        if (StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{eTags, eTagToMatch})) {
            for (String eTag : StringUtils.stripAll((String[])StringUtils.split((String)eTags, (String)","))) {
                if (!StringUtils.equalsIgnoreCase((CharSequence)ControllerUtils.spicAndSpan((String)eTag), (CharSequence)ControllerUtils.spicAndSpan((String)eTagToMatch))) continue;
                return true;
            }
        }
        return false;
    }

    private static String spicAndSpan(String header) {
        return StringUtils.remove((String)StringUtils.stripStart((String)header, (String)"W/"), (String)"\"");
    }
}

