/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.thumbnail.service.impl;

import com.amazonaws.services.s3.model.S3Object;
import eu.europeana.features.S3ObjectStorageClient;
import eu.europeana.thumbnail.model.MediaStream;
import eu.europeana.thumbnail.service.MediaStorageService;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class MediaStorageServiceImpl
implements MediaStorageService {
    private static final Logger LOG = LogManager.getLogger(MediaStorageServiceImpl.class);
    private String name;
    private S3ObjectStorageClient objectStorageClient;

    public MediaStorageServiceImpl(String name, S3ObjectStorageClient objectStorageClient) {
        this.name = name;
        this.objectStorageClient = objectStorageClient;
    }

    public Boolean checkIfExists(String id) {
        return this.objectStorageClient.isObjectAvailable(id);
    }

    public MediaStream retrieve(String id, String originalUrl) {
        LOG.debug("Retrieving file with id {}, url = {}", (Object)id, (Object)originalUrl);
        S3Object obj = this.objectStorageClient.getObject(id);
        if (obj == null) {
            return null;
        }
        return new MediaStream(id, originalUrl, obj);
    }

    public String getName() {
        return this.name;
    }
}

