/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.thumbnail.service.impl;

import eu.europeana.thumbnail.model.ImageSize;
import eu.europeana.thumbnail.model.MediaStream;
import eu.europeana.thumbnail.service.MediaStorageService;
import eu.europeana.thumbnail.utils.IiifUtils;
import jakarta.validation.constraints.Pattern;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import org.apache.commons.lang3.NotImplementedException;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.stereotype.Component;
import org.springframework.validation.annotation.Validated;

@Validated
@Component
public class IiifImageServerImpl
implements MediaStorageService {
    public static final String STORAGE_NAME = "IIIF-IS";
    private static final Logger LOG = LogManager.getLogger(IiifImageServerImpl.class);
    private static final String INVALID_URL_MESSAGE = "Not a valid url";

    public Boolean checkIfExists(String id) {
        throw new NotImplementedException("Not implemented");
    }

    public MediaStream retrieve(String id, String originalUrl) {
        String imageUrl;
        LOG.debug("Retrieving file from IIIF image server with id {}, url = {}", (Object)id, (Object)originalUrl);
        if (StringUtils.isEmpty((CharSequence)originalUrl)) {
            LOG.debug("No originalUrl provided, skipping retrieval from IIIF Image server");
            return null;
        }
        String width = String.valueOf(ImageSize.LARGE.getWidth());
        if (id.endsWith(ImageSize.MEDIUM.name())) {
            width = String.valueOf(ImageSize.MEDIUM.getWidth());
        }
        if ((imageUrl = IiifUtils.getEuropeanaIiifThumbnailUrl((String)originalUrl, (String)width)) == null) {
            LOG.debug("No Europeana IIIF image, skipping retrieval from IIIF Image server");
            return null;
        }
        InputStream content = this.retrieve(imageUrl);
        if (content == null) {
            return null;
        }
        return new MediaStream(id, imageUrl, content);
    }

    public InputStream retrieve(@Pattern(regexp="^(https?|ftp)://.*$", message="Not a valid url") @Pattern(regexp="^(https?|ftp)://.*$", message="Not a valid url") String originalUrl) {
        try {
            return new BufferedInputStream(new URL(originalUrl).openStream());
        }
        catch (MalformedURLException e) {
            LOG.error("'{}' is not a valid url", (Object)originalUrl, (Object)e);
        }
        catch (IOException e) {
            LOG.error("Error reading image '{}' from IIIF image server", (Object)originalUrl, (Object)e);
        }
        return null;
    }

    public String getName() {
        return STORAGE_NAME;
    }
}

