/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.thumbnail.model;

import com.amazonaws.services.s3.model.ObjectMetadata;
import com.amazonaws.services.s3.model.S3Object;
import java.io.IOException;
import java.io.InputStream;
import org.joda.time.DateTime;

public class MediaStream {
    private final String id;
    private final String originalUrl;
    private final InputStream inputStream;
    private final ObjectMetadata metadata;
    private final S3Object s3object;
    private boolean closed = false;

    public MediaStream(String id, String originalUrl, InputStream inputStream) {
        this(id, originalUrl, inputStream, null);
    }

    public MediaStream(String id, String originalUrl, InputStream inputStream, ObjectMetadata metadata) {
        this.id = id;
        this.originalUrl = originalUrl;
        this.inputStream = inputStream;
        this.metadata = metadata;
        this.s3object = null;
    }

    public MediaStream(String id, String originalUrl, S3Object s3object) {
        this.id = id;
        this.originalUrl = originalUrl;
        this.inputStream = null;
        this.metadata = s3object.getObjectMetadata();
        this.s3object = s3object;
    }

    public String getId() {
        return this.id;
    }

    public String getOriginalUrl() {
        return this.originalUrl;
    }

    public InputStream getInputStream() {
        if (this.inputStream != null) {
            return this.inputStream;
        }
        return this.s3object.getObjectContent().getDelegateStream();
    }

    public boolean hasMetadata() {
        return this.metadata != null;
    }

    public long getContentLength() {
        if (this.hasMetadata()) {
            return this.metadata.getContentLength();
        }
        return 0L;
    }

    public DateTime getLastModified() {
        if (this.hasMetadata() && this.metadata.getLastModified() != null) {
            return new DateTime(this.metadata.getLastModified().getTime());
        }
        return null;
    }

    public String getETag() {
        if (this.hasMetadata()) {
            return this.metadata.getETag();
        }
        return null;
    }

    public void close() {
        try {
            if (this.inputStream != null) {
                this.inputStream.close();
            } else {
                this.s3object.close();
            }
            this.closed = true;
        }
        catch (IOException e) {
            throw new RuntimeException("Error closing s3Object " + this.id, e);
        }
    }

    public boolean isClosed() {
        return this.closed;
    }
}

