/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.thumbnail.config;

import com.amazonaws.ClientConfiguration;
import eu.europeana.features.S3ObjectStorageClient;
import eu.europeana.thumbnail.exception.ConfigurationException;
import eu.europeana.thumbnail.service.MediaStorageService;
import eu.europeana.thumbnail.service.impl.IiifImageServerImpl;
import eu.europeana.thumbnail.service.impl.MediaStorageServiceImpl;
import jakarta.annotation.PostConstruct;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.PropertySource;
import org.springframework.context.annotation.PropertySources;
import org.springframework.core.env.Environment;

@Configuration
@PropertySources(value={@PropertySource(value={"classpath:thumbnail.properties"}), @PropertySource(value={"classpath:thumbnail.user.properties"}, ignoreResourceNotFound=true)})
public class StorageRoutes {
    private static final Logger LOG = LogManager.getLogger(StorageRoutes.class);
    private static final String PROP_ROUTE = "route";
    private static final String PROP_ROUTE_NAME = "name";
    private static final String PROP_ROUTE_STORAGE = "storage";
    private static final String PROP_S3_KEY = "s3.key";
    private static final String PROP_S3_SECRET = "s3.secret";
    private static final String PROP_S3_REGION = "s3.region";
    private static final String PROP_S3_BUCKET = "s3.bucket";
    private static final String PROP_S3_ENDPOINT = "s3.endpoint";
    private static final String PROP_VALIDATE_CONNECTION_AFTER = "s3.validate.connection";
    private static final String PROP_MAX_CONNECTIONS = "s3.max.connections";
    private static final String PROPERTY_SEPARATOR = ".";
    private static final String VALUE_SEPARATOR = ",";
    private String defaultRoute;
    private Map<String, List<MediaStorageService>> routeToStorages = new HashMap();
    private Map<String, MediaStorageService> storageNameToService = new HashMap();
    private Environment environment;

    public StorageRoutes(Environment environment) {
        this.environment = environment;
    }

    @PostConstruct
    private void initRoutesToStorage() {
        int i = 1;
        String routeKeyNr = PROP_ROUTE + i;
        String routeKeyName = routeKeyNr + ".name";
        while (this.environment.containsProperty(routeKeyName)) {
            String routePropStorage;
            String[] routes = this.environment.getProperty(routeKeyName).split(VALUE_SEPARATOR);
            if (this.defaultRoute == null) {
                this.defaultRoute = routes[0].trim();
            }
            if (this.environment.containsProperty(routePropStorage = routeKeyNr + ".storage")) {
                String[] storages = this.environment.getProperty(routePropStorage).split(VALUE_SEPARATOR);
                for (String route : routes) {
                    String cleanRoute = route.trim();
                    LOG.info("Adding route {} with storage(s) {}", (Object)cleanRoute, (Object)storages);
                    this.routeToStorages.put(cleanRoute, this.generateStorageServices(storages));
                }
            } else {
                throw new ConfigurationException("No storage defined for route(s)" + routes);
            }
            routeKeyNr = PROP_ROUTE + ++i;
            routeKeyName = routeKeyNr + ".name";
        }
        if (this.routeToStorages.isEmpty()) {
            throw new ConfigurationException("No routes and storages configured!");
        }
    }

    private ArrayList<MediaStorageService> generateStorageServices(String[] storageNames) {
        ArrayList<MediaStorageService> result = new ArrayList<MediaStorageService>();
        for (String storageName : storageNames) {
            String name = storageName.trim();
            MediaStorageService service = (MediaStorageService)this.storageNameToService.get(name);
            if (service == null) {
                service = this.createNewService(name);
            } else {
                LOG.info("Reusing existing service {}", (Object)service.getName());
            }
            this.storageNameToService.put(name, service);
            result.add(service);
        }
        return result;
    }

    private MediaStorageService createNewService(String storageName) {
        LOG.info("Setting up new client {}...", (Object)storageName);
        if (storageName.equalsIgnoreCase("IIIF-IS")) {
            LOG.debug("Creating IIIF Image Server client {}...", (Object)storageName);
            return new IiifImageServerImpl();
        }
        String key = this.environment.getRequiredProperty(storageName + ".s3.key");
        String secret = this.environment.getRequiredProperty(storageName + ".s3.secret");
        String region = this.environment.getRequiredProperty(storageName + ".s3.region");
        String bucket = this.environment.getRequiredProperty(storageName + ".s3.bucket");
        String endpoint = this.environment.getProperty(storageName + ".s3.endpoint");
        Integer maxConnections = (Integer)this.environment.getProperty(storageName + ".s3.max.connections", Integer.class, (Object)50);
        Integer validateAfter = (Integer)this.environment.getProperty(storageName + ".s3.validate.connection", Integer.class, (Object)-1);
        ClientConfiguration config = new ClientConfiguration();
        if (maxConnections > 1) {
            config.setMaxConnections(maxConnections.intValue());
            LOG.info("Configured maximum connections = {}", (Object)config.getMaxConnections());
        }
        if (validateAfter >= 100) {
            config.withValidateAfterInactivityMillis(validateAfter.intValue());
            LOG.info("Configured validating connection after = {} ms", (Object)config.getValidateAfterInactivityMillis());
        }
        if (StringUtils.isEmpty((CharSequence)endpoint)) {
            LOG.debug("Creating Amazon storage client {}...", (Object)storageName);
            return new MediaStorageServiceImpl(storageName, new S3ObjectStorageClient(key, secret, region, bucket, config));
        }
        LOG.debug("Creating IBM storage client {}...", (Object)storageName);
        return new MediaStorageServiceImpl(storageName, new S3ObjectStorageClient(key, secret, region, bucket, endpoint, config));
    }

    public String getDefaultRoute() {
        return this.defaultRoute;
    }

    public Map<String, List<MediaStorageService>> getRoutesMap() {
        return this.routeToStorages;
    }
}

