/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.thumbnail.web;

import eu.europeana.api.commons.error.EuropeanaApiException;
import eu.europeana.thumbnail.exception.ThumbnailInvalidUrlException;
import eu.europeana.thumbnail.exception.ThumbnailNotFoundException;
import eu.europeana.thumbnail.model.MediaFile;
import eu.europeana.thumbnail.service.StoragesService;
import eu.europeana.thumbnail.web.AbstractController;
import java.util.Optional;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.validation.constraints.Pattern;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.context.request.WebRequest;

@RestController
@RequestMapping(value={"/thumbnail"})
@Validated
public class ThumbnailControllerV3
extends AbstractController {
    private static final Logger LOG = LogManager.getLogger(ThumbnailControllerV3.class);
    protected static final String SIZE_ERROR_MESSAGE = "Invalid size. Supported values are 200 and 400";
    protected static final String ID_ERROR_MESSAGE = "Invalid or empty id";
    protected static final String URL_ERROR_MESSAGE = "Either Size or Id is missing. Correct url is /v3/{size}/{id}";

    public ThumbnailControllerV3(StoragesService storagesService) {
        super(storagesService);
    }

    @GetMapping(value={"/v3//{id}"})
    public ResponseEntity<byte[]> thumbnailByUrlV3InvalidUrl() throws ThumbnailInvalidUrlException {
        throw new ThumbnailInvalidUrlException(URL_ERROR_MESSAGE);
    }

    @GetMapping(value={"/v3"})
    public ResponseEntity<byte[]> thumbnailByUrlV3EmptyUrl() throws ThumbnailInvalidUrlException {
        throw new ThumbnailInvalidUrlException(URL_ERROR_MESSAGE);
    }

    @GetMapping(value={"/v3/{size}/{id}"})
    public ResponseEntity<byte[]> thumbnailByUrlV3(@PathVariable(value="size", required=false) @Pattern(regexp="^(200|400)$", message="Invalid size. Supported values are 200 and 400") @Pattern(regexp="^(200|400)$", message="Invalid size. Supported values are 200 and 400") String size, @PathVariable(value="id") String id, WebRequest webRequest, HttpServletRequest request, HttpServletResponse response) throws EuropeanaApiException {
        Optional mediaFile;
        long startTime = 0L;
        if (LOG.isDebugEnabled()) {
            startTime = System.nanoTime();
            LOG.debug("Thumbnail id = {}, size = {}", (Object)id, (Object)size);
        }
        String idWithoutExtension = id;
        String extension = null;
        int i = id.lastIndexOf(46);
        if (i == 0) {
            throw new ThumbnailInvalidUrlException(ID_ERROR_MESSAGE);
        }
        if (i > 0) {
            idWithoutExtension = id.substring(0, i);
            extension = id.substring(i);
            LOG.debug("Thumbnail cleaned id = {}, extension = {}", (Object)idWithoutExtension, (Object)extension);
        }
        if ((mediaFile = this.retrieveThumbnail(request, idWithoutExtension, extension, Integer.valueOf(size))).isEmpty()) {
            this.logRequestDuration(startTime, "Id = " + id + ", status = " + HttpStatus.NOT_FOUND);
            throw new ThumbnailNotFoundException();
        }
        ResponseEntity result = this.generateResponse(webRequest, response, (MediaFile)mediaFile.get());
        this.logRequestDuration(startTime, "Id = " + id + ", status = " + response.getStatus());
        return result;
    }
}

