/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.thumbnail.service;

import eu.europeana.thumbnail.config.StorageRoutes;
import eu.europeana.thumbnail.service.MediaStorageService;
import java.util.List;
import java.util.Map;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.stereotype.Service;

@Service
public class StoragesService {
    private static final Logger LOG = LogManager.getLogger(StoragesService.class);
    private StorageRoutes storageRoutes;

    public StoragesService(StorageRoutes storageRoutes) {
        this.storageRoutes = storageRoutes;
    }

    public List<MediaStorageService> getStorages(String route) {
        String topLevelName = this.getTopLevelName(route);
        List result = (List)this.storageRoutes.getRoutesMap().get(topLevelName);
        if (result != null) {
            LOG.debug("Route {} - found exact match", (Object)topLevelName);
            return result;
        }
        for (Map.Entry entry : this.storageRoutes.getRoutesMap().entrySet()) {
            if (!topLevelName.contains((CharSequence)entry.getKey())) continue;
            LOG.debug("Route {} - matched with {}", (Object)topLevelName, entry.getKey());
            return (List)entry.getValue();
        }
        LOG.warn("Route {} - no configured storage found, using default", (Object)topLevelName);
        return (List)this.storageRoutes.getRoutesMap().get(this.storageRoutes.getDefaultRoute());
    }

    private String getTopLevelName(String route) {
        int i = route.indexOf(46);
        if (i >= 0) {
            return route.substring(0, i);
        }
        return route;
    }
}

