/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.thumbnail.config;

import eu.europeana.features.ObjectStorageClient;
import eu.europeana.features.S3ObjectStorageClient;
import eu.europeana.thumbnail.exception.ConfigurationException;
import eu.europeana.thumbnail.service.MediaStorageService;
import eu.europeana.thumbnail.service.impl.IiifImageServerImpl;
import eu.europeana.thumbnail.service.impl.MediaStorageServiceImpl;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.PostConstruct;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.PropertySource;
import org.springframework.context.annotation.PropertySources;
import org.springframework.core.env.Environment;
import org.springframework.util.StringUtils;

@Configuration
@PropertySources(value={@PropertySource(value={"classpath:thumbnail.properties"}), @PropertySource(value={"classpath:thumbnail.user.properties"}, ignoreResourceNotFound=true)})
public class StorageRoutes {
    private static final Logger LOG = LogManager.getLogger(StorageRoutes.class);
    private static final String PROP_ROUTE = "route";
    private static final String PROP_ROUTE_NAME = "name";
    private static final String PROP_ROUTE_STORAGE = "storage";
    private static final String PROP_S3_KEY = "s3.key";
    private static final String PROP_S3_SECRET = "s3.secret";
    private static final String PROP_S3_REGION = "s3.region";
    private static final String PROP_S3_BUCKET = "s3.bucket";
    private static final String PROP_S3_ENDPOINT = "s3.endpoint";
    private static final String PROPERTY_SEPARATOR = ".";
    private static final String VALUE_SEPARATOR = ",";
    private String defaultRoute;
    private Map<String, List<MediaStorageService>> routeToStorages = new HashMap();
    private Map<String, MediaStorageService> storageNameToService = new HashMap();
    private Environment environment;

    public StorageRoutes(Environment environment) {
        this.environment = environment;
    }

    @PostConstruct
    private void initRoutesToStorage() {
        int i = 1;
        String routeKeyNr = PROP_ROUTE + i;
        String routeKeyName = routeKeyNr + ".name";
        while (this.environment.containsProperty(routeKeyName)) {
            String routePropStorage;
            String[] routes = this.environment.getProperty(routeKeyName).split(VALUE_SEPARATOR);
            if (this.defaultRoute == null) {
                this.defaultRoute = routes[0].trim();
            }
            if (this.environment.containsProperty(routePropStorage = routeKeyNr + ".storage")) {
                String[] storages = this.environment.getProperty(routePropStorage).split(VALUE_SEPARATOR);
                for (String route : routes) {
                    String cleanRoute = route.trim();
                    LOG.info("Adding route {} with storage(s) {}", (Object)cleanRoute, (Object)storages);
                    this.routeToStorages.put(cleanRoute, this.generateStorageServices(storages));
                }
            } else {
                throw new ConfigurationException("No storage defined for route(s)" + routes);
            }
            routeKeyNr = PROP_ROUTE + ++i;
            routeKeyName = routeKeyNr + ".name";
        }
        if (this.routeToStorages.isEmpty()) {
            throw new ConfigurationException("No routes and storages configured!");
        }
    }

    private ArrayList<MediaStorageService> generateStorageServices(String[] storageNames) {
        ArrayList<MediaStorageService> result = new ArrayList<MediaStorageService>();
        for (String storageName : storageNames) {
            String name = storageName.trim();
            MediaStorageService service = (MediaStorageService)this.storageNameToService.get(name);
            if (service == null) {
                service = this.createNewService(name);
            } else {
                LOG.info("Reusing existing service {}", (Object)service.getName());
            }
            this.storageNameToService.put(name, service);
            result.add(service);
        }
        return result;
    }

    private MediaStorageService createNewService(String storageName) {
        if (storageName.equalsIgnoreCase("IIIF-IS")) {
            LOG.debug("Creating IIIF Image Server client {}...", (Object)storageName);
            return new IiifImageServerImpl();
        }
        String key = this.environment.getRequiredProperty(storageName + ".s3.key");
        String secret = this.environment.getRequiredProperty(storageName + ".s3.secret");
        String region = this.environment.getRequiredProperty(storageName + ".s3.region");
        String bucket = this.environment.getRequiredProperty(storageName + ".s3.bucket");
        String endpoint = this.environment.getProperty(storageName + ".s3.endpoint");
        if (StringUtils.isEmpty((Object)endpoint)) {
            LOG.debug("Creating Amazon storage client {}...", (Object)storageName);
            return new MediaStorageServiceImpl(storageName, (ObjectStorageClient)new S3ObjectStorageClient(key, secret, region, bucket));
        }
        LOG.debug("Creating IBM storage client {}...", (Object)storageName);
        return new MediaStorageServiceImpl(storageName, (ObjectStorageClient)new S3ObjectStorageClient(key, secret, region, bucket, endpoint));
    }

    public String getDefaultRoute() {
        return this.defaultRoute;
    }

    public Map<String, List<MediaStorageService>> getRoutesMap() {
        return this.routeToStorages;
    }
}

