/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.thumbnail.web;

import eu.europeana.thumbnail.model.ImageSize;
import eu.europeana.thumbnail.model.MediaFile;
import eu.europeana.thumbnail.service.MediaStorageService;
import eu.europeana.thumbnail.service.StoragesService;
import eu.europeana.thumbnail.utils.ControllerUtils;
import eu.europeana.thumbnail.utils.HashUtils;
import java.util.List;
import java.util.Locale;
import java.util.Optional;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.lang.NonNull;
import org.springframework.util.MultiValueMap;
import org.springframework.web.context.request.WebRequest;

public abstract class AbstractController {
    private static final Logger LOG = LogManager.getLogger(AbstractController.class);
    private static final long DURATION_CONVERTER = 1000000L;
    protected StoragesService storagesService;

    public AbstractController(StoragesService storagesService) {
        this.storagesService = storagesService;
    }

    protected Optional<MediaFile> retrieveThumbnail(HttpServletRequest request, String fileId, String originalUrl, Integer width) {
        String id = fileId;
        if (StringUtils.isEmpty((CharSequence)fileId)) {
            id = this.computeId(originalUrl);
        }
        id = this.addWidth(id, width);
        Object serverName = request.getServerName();
        if ("localhost".equalsIgnoreCase((String)serverName)) {
            serverName = (String)serverName + ":" + request.getServerPort();
        }
        MediaFile result = null;
        List mediaStorageServices = this.storagesService.getStorages((String)serverName);
        for (MediaStorageService mss : mediaStorageServices) {
            result = mss.retrieveAsMediaFile(id, originalUrl);
            if (result == null) {
                LOG.debug("File {} not present in storage {}", (Object)id, (Object)mss.getName());
                continue;
            }
            LOG.debug("File {} found in storage {}", (Object)id, (Object)mss.getName());
            break;
        }
        return Optional.ofNullable(result);
    }

    private String computeId(String resourceUrl) {
        return HashUtils.getMD5((String)resourceUrl);
    }

    private String addWidth(String id, Integer resourceWidth) {
        String width = ImageSize.LARGE.name();
        if (resourceWidth != null && resourceWidth.intValue() == ImageSize.MEDIUM.getWidth()) {
            width = ImageSize.MEDIUM.name();
        }
        return id + "-" + width;
    }

    protected ResponseEntity<byte[]> generateResponse(WebRequest webRequest, HttpServletResponse response, @NonNull MediaFile mediaFile) {
        ControllerUtils.addDefaultResponseHeaders((HttpServletResponse)response);
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(this.getMediaType(mediaFile.getOriginalUrl()));
        if (ControllerUtils.checkForNotModified((MediaFile)mediaFile, (WebRequest)webRequest)) {
            return null;
        }
        if (ControllerUtils.checkForPrecondition((MediaFile)mediaFile, (WebRequest)webRequest)) {
            response.setStatus(HttpStatus.PRECONDITION_FAILED.value());
            return null;
        }
        return new ResponseEntity((Object)mediaFile.getContent(), (MultiValueMap)headers, HttpStatus.OK);
    }

    private MediaType getMediaType(String url) {
        if (url == null) {
            return MediaType.IMAGE_JPEG;
        }
        String urlLow = url.toLowerCase(Locale.GERMAN);
        if (urlLow.endsWith(".png") || urlLow.endsWith(".pdf")) {
            return MediaType.IMAGE_PNG;
        }
        return MediaType.IMAGE_JPEG;
    }

    protected void logRequestDuration(long startTime, String requestInfo) {
        if (LOG.isDebugEnabled()) {
            Long duration = (System.nanoTime() - startTime) / 1000000L;
            if (StringUtils.isBlank((CharSequence)requestInfo)) {
                LOG.debug("Processing time = {} ms ", (Object)duration);
            } else {
                LOG.debug("{}, processing time = {} ms ", (Object)requestInfo, (Object)duration);
            }
        }
    }
}

