/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.thumbnail.web;

import eu.europeana.thumbnail.model.MediaFile;
import eu.europeana.thumbnail.service.StoragesService;
import eu.europeana.thumbnail.web.AbstractController;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.validation.constraints.Pattern;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.http.ResponseEntity;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.context.request.WebRequest;

@RestController
@RequestMapping(value={"/thumbnail"})
@Validated
public class ThumbnailControllerV3
extends AbstractController {
    private static final Logger LOG = LogManager.getLogger(ThumbnailControllerV3.class);
    private static final String SIZE_ERROR_MESSAGE = "Invalid size. Supported values are 200 and 400";

    public ThumbnailControllerV3(StoragesService storagesService) {
        super(storagesService);
    }

    @GetMapping(value={"/v3/{size}/{id}"})
    public ResponseEntity<byte[]> thumbnailByUrlV3(@PathVariable(value="size") @Pattern(regexp="^(200|400)$", message="Invalid size. Supported values are 200 and 400") @Pattern(regexp="^(200|400)$", message="Invalid size. Supported values are 200 and 400") String size, @PathVariable(value="id") String id, WebRequest webRequest, HttpServletRequest request, HttpServletResponse response) {
        long startTime = 0L;
        if (LOG.isDebugEnabled()) {
            startTime = System.nanoTime();
            LOG.debug("Thumbnail id = {}, size = {}", (Object)id, (Object)size);
        }
        String idWithoutExtension = id;
        String extension = null;
        int i = id.lastIndexOf(46);
        if (i > 0) {
            idWithoutExtension = id.substring(0, i);
            extension = id.substring(i);
            LOG.debug("Thumbnail cleaned id = {}, extension = {}", (Object)idWithoutExtension, (Object)extension);
        }
        MediaFile mediaFile = this.retrieveThumbnail(request, idWithoutExtension, extension, Integer.valueOf(size));
        ResponseEntity result = this.generateResponse(webRequest, response, mediaFile);
        this.logRequestDuration(startTime, "Id = " + id + ", status = " + response.getStatus());
        return result;
    }
}

