/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.thumbnail.web;

import eu.europeana.thumbnail.model.ImageSize;
import eu.europeana.thumbnail.model.MediaFile;
import eu.europeana.thumbnail.service.StoragesService;
import eu.europeana.thumbnail.web.AbstractController;
import java.io.IOException;
import java.io.InputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.validation.constraints.Pattern;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.util.MultiValueMap;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.context.request.WebRequest;

@RestController
@Validated
public class ThumbnailControllerV2
extends AbstractController {
    private static final Logger LOG = LogManager.getLogger(ThumbnailControllerV2.class);
    private static final String INVALID_URL_MESSAGE = "INVALID URL";

    public ThumbnailControllerV2(StoragesService storagesService) {
        super(storagesService);
    }

    @GetMapping(value={"/api/v2/thumbnail-by-url.json", "/thumbnail/v2/url.json"})
    public ResponseEntity<byte[]> thumbnailByUrlV2(@RequestParam(value="uri") @Pattern(regexp="^(https?|ftp)://.*$", message="INVALID URL") @Pattern(regexp="^(https?|ftp)://.*$", message="INVALID URL") String url, @RequestParam(value="size", required=false, defaultValue="w400") String size, @RequestParam(value="type", required=false, defaultValue="IMAGE") String type, WebRequest webRequest, HttpServletRequest request, HttpServletResponse response) {
        MediaFile mediaFile;
        ResponseEntity result;
        long startTime = 0L;
        if (LOG.isDebugEnabled()) {
            startTime = System.nanoTime();
            LOG.debug("Url = {}, size = {}, type = {}", (Object)url, (Object)size, (Object)type);
        }
        if ((result = this.generateResponse(webRequest, response, mediaFile = this.retrieveThumbnail(request, null, url, Integer.valueOf(this.getWidth(size))))) != null && result.getStatusCode() == HttpStatus.NOT_FOUND) {
            HttpHeaders headers = new HttpHeaders();
            headers.setContentType(MediaType.IMAGE_PNG);
            result = new ResponseEntity((Object)this.getDefaultThumbnailForNotFoundResourceByType(type), (MultiValueMap)headers, HttpStatus.OK);
        }
        this.logRequestDuration(startTime, "Url = " + url + ", status = " + response.getStatus());
        return result;
    }

    private int getWidth(String size) {
        if (StringUtils.equalsIgnoreCase((CharSequence)size, (CharSequence)"w200") || StringUtils.equalsIgnoreCase((CharSequence)size, (CharSequence)"200")) {
            return ImageSize.MEDIUM.getWidth();
        }
        return ImageSize.LARGE.getWidth();
    }

    private byte[] getDefaultImage(String path) {
        byte[] result = null;
        try (InputStream in = this.getClass().getResourceAsStream(path);){
            result = IOUtils.toByteArray((InputStream)in);
        }
        catch (IOException e) {
            LOG.error("Error reading default thumbnail file", (Throwable)e);
        }
        return result;
    }

    private byte[] getDefaultThumbnailForNotFoundResourceByType(String type) {
        String defaultImageName;
        switch (StringUtils.upperCase((String)type)) {
            case "IMAGE": {
                defaultImageName = "EU_thumbnails_image.png";
                break;
            }
            case "SOUND": {
                defaultImageName = "EU_thumbnails_sound.png";
                break;
            }
            case "VIDEO": {
                defaultImageName = "EU_thumbnails_video.png";
                break;
            }
            case "TEXT": {
                defaultImageName = "EU_thumbnails_text.png";
                break;
            }
            case "3D": {
                defaultImageName = "EU_thumbnails_3d.png";
                break;
            }
            default: {
                defaultImageName = "EU_thumbnails_image.png";
            }
        }
        return this.getDefaultImage("/images/" + defaultImageName);
    }
}

