/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.thumbnail.utils;

import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import org.apache.logging.log4j.LogManager;

public final class HashUtils {
    private static MessageDigest messageDigest;

    private HashUtils() {
    }

    public static String getMD5(String resourceUrl) {
        messageDigest.reset();
        messageDigest.update(resourceUrl.getBytes(StandardCharsets.UTF_8));
        byte[] resultByte = messageDigest.digest();
        StringBuilder sb = new StringBuilder();
        for (byte aResultByte : resultByte) {
            sb.append(Integer.toString((aResultByte & 0xFF) + 256, 16).substring(1));
        }
        return sb.toString();
    }

    static {
        try {
            messageDigest = MessageDigest.getInstance("MD5");
        }
        catch (NoSuchAlgorithmException e) {
            LogManager.getLogger().error("Could not find MD5 algorithm", (Throwable)e);
        }
    }
}

