/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.thumbnail.service.impl;

import eu.europeana.domain.ObjectMetadata;
import eu.europeana.thumbnail.model.ImageSize;
import eu.europeana.thumbnail.model.MediaFile;
import eu.europeana.thumbnail.service.MediaStorageService;
import eu.europeana.thumbnail.utils.IiifUtils;
import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.Locale;
import javax.validation.constraints.Pattern;
import org.apache.commons.lang3.NotImplementedException;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class IiifImageServerImpl
implements MediaStorageService {
    public static final String STORAGE_NAME = "IIIF-IS";
    private static final Logger LOG = LogManager.getLogger(IiifImageServerImpl.class);
    private static final String INVALID_URL_MESSAGE = "Not a valid url";

    public Boolean checkIfExists(String id) {
        throw new NotImplementedException("Not implemented");
    }

    public MediaFile retrieveAsMediaFile(String id, String originalUrl) {
        String imageUrl;
        LOG.debug("Retrieving file from IIIF image server with id {}, url = {}", (Object)id, (Object)originalUrl);
        if (StringUtils.isEmpty((CharSequence)originalUrl)) {
            LOG.debug("No originalUrl provided, skipping retrieval from IIIF Image server");
            return null;
        }
        String width = String.valueOf(ImageSize.LARGE.getWidth());
        if (id.endsWith(ImageSize.MEDIUM.name())) {
            width = String.valueOf(ImageSize.MEDIUM.getWidth());
        }
        if ((imageUrl = IiifUtils.getEuropeanaIiifThumbnailUrl((String)originalUrl, (String)width)) == null) {
            LOG.debug("No Europeana IIIF image, skipping retrieval from IIIF Image server");
            return null;
        }
        byte[] content = this.retrieveContent(imageUrl);
        if (content != null && content.length > 0) {
            return new MediaFile(null, imageUrl, content);
        }
        return null;
    }

    /*
     * Enabled aggressive exception aggregation
     */
    public byte[] retrieveContent(@Pattern(regexp="^(https?|ftp)://.*$", message="Not a valid url") @Pattern(regexp="^(https?|ftp)://.*$", message="Not a valid url") String originalUrl) {
        try (BufferedInputStream in = new BufferedInputStream(new URL(originalUrl).openStream());){
            byte[] data;
            ByteArrayOutputStream out;
            block17: {
                byte[] byArray;
                out = new ByteArrayOutputStream();
                try {
                    int n;
                    byte[] buf = new byte[1024];
                    while (-1 != (n = ((InputStream)in).read(buf))) {
                        out.write(buf, 0, n);
                    }
                    data = out.toByteArray();
                    if (data.length != 0 && !new String(data, StandardCharsets.UTF_8).toLowerCase(Locale.GERMAN).startsWith("<html>")) break block17;
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("IIIF Image server returned error message: {}", (Object)String.valueOf(data));
                    }
                    byArray = new byte[]{};
                }
                catch (Throwable throwable) {
                    try {
                        out.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
                out.close();
                return byArray;
            }
            byte[] byArray = data;
            out.close();
            return byArray;
        }
        catch (MalformedURLException e) {
            LOG.error("'{}' is not a valid url", (Object)originalUrl, (Object)e);
        }
        catch (IOException e) {
            LOG.error("Error reading image '{}' from IIIF image server", (Object)originalUrl, (Object)e);
        }
        return new byte[0];
    }

    public ObjectMetadata retrieveMetaData(String id) {
        throw new NotImplementedException("Not implemented");
    }

    public String getName() {
        return STORAGE_NAME;
    }
}

